/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.util.Locale;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.Duration;

@ServerSide
@ComputeEngineSide
public class Durations {
    private static final String MINUTES_FORMAT = "%smin";
    private static final String HOURS_FORMAT = "%sh";
    private static final String DAYS_FORMAT = "%sd";
    private static final int HOURS_IN_DAY = 8;

    public Duration create(long minutes) {
        return Duration.create(minutes);
    }

    public Duration decode(String duration) {
        return Duration.decode(duration, 8);
    }

    public String encode(Duration duration) {
        return duration.encode(8);
    }

    @Deprecated
    public String format(Locale locale, Duration duration, DurationFormat format) {
        return this.format(duration);
    }

    @Deprecated
    public String format(Locale locale, Duration duration) {
        return this.format(duration);
    }

    public String format(Duration duration) {
        long durationInMinutes = duration.toMinutes();
        if (durationInMinutes == 0L) {
            return "0";
        }
        boolean isNegative = durationInMinutes < 0L;
        long absDuration = Math.abs(durationInMinutes);
        int days = Double.valueOf((double)absDuration / 8.0 / 60.0).intValue();
        long remainingDuration = absDuration - (long)(days * 8 * 60);
        int hours = Double.valueOf((double)remainingDuration / 60.0).intValue();
        int minutes = (int)(remainingDuration -= (long)(hours * 60));
        return Durations.format(days, hours, minutes, isNegative);
    }

    private static String format(int days, int hours, int minutes, boolean isNegative) {
        StringBuilder message = new StringBuilder();
        if (days > 0) {
            message.append(String.format(DAYS_FORMAT, isNegative ? -1 * days : days));
        }
        if (Durations.displayHours(days, hours)) {
            Durations.addSpaceIfNeeded(message);
            message.append(String.format(HOURS_FORMAT, isNegative && message.length() == 0 ? -1 * hours : hours));
        }
        if (Durations.displayMinutes(days, hours, minutes)) {
            Durations.addSpaceIfNeeded(message);
            message.append(String.format(MINUTES_FORMAT, isNegative && message.length() == 0 ? -1 * minutes : minutes));
        }
        return message.toString();
    }

    private static boolean displayHours(int days, int hours) {
        return hours > 0 && days < 10;
    }

    private static boolean displayMinutes(int days, int hours, int minutes) {
        return minutes > 0 && hours < 10 && days == 0;
    }

    private static void addSpaceIfNeeded(StringBuilder message) {
        if (message.length() > 0) {
            message.append(" ");
        }
    }

    @Deprecated
    public static enum DurationFormat {
        SHORT;

    }
}

