/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import java.util.function.Supplier;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.ScannerProperties;
import org.sonar.scanner.repository.ProjectRepositories;
import org.sonar.scanner.repository.ProjectRepositoriesLoader;
import org.sonar.scanner.scan.branch.BranchConfiguration;

public class ProjectRepositoriesSupplier
implements Supplier<ProjectRepositories> {
    private static final Logger LOG = Loggers.get(ProjectRepositoriesSupplier.class);
    private static final String LOG_MSG = "Load project repositories";
    private final ProjectRepositoriesLoader loader;
    private final ScannerProperties scannerProperties;
    private final BranchConfiguration branchConfig;
    private ProjectRepositories project = null;

    public ProjectRepositoriesSupplier(ProjectRepositoriesLoader loader, ScannerProperties scannerProperties, BranchConfiguration branchConfig) {
        this.loader = loader;
        this.scannerProperties = scannerProperties;
        this.branchConfig = branchConfig;
    }

    @Override
    public ProjectRepositories get() {
        if (this.project == null) {
            Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG);
            this.project = this.loader.load(this.scannerProperties.getProjectKey(), this.branchConfig.referenceBranchName());
            profiler.stopInfo();
        }
        return this.project;
    }
}

