/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.scanner.bootstrap.GlobalConfiguration;
import org.sonar.scanner.bootstrap.GlobalServerSettings;
import org.sonar.scanner.scan.ModuleConfiguration;
import org.sonar.scanner.scan.ProjectServerSettings;

public class ModuleConfigurationProvider
extends ProviderAdapter {
    private ModuleConfiguration moduleConfiguration;

    public ModuleConfiguration provide(GlobalConfiguration globalConfig, DefaultInputModule module, GlobalServerSettings globalServerSettings, ProjectServerSettings projectServerSettings) {
        if (this.moduleConfiguration == null) {
            LinkedHashMap<String, String> settings = new LinkedHashMap<String, String>();
            settings.putAll(globalServerSettings.properties());
            settings.putAll(projectServerSettings.properties());
            ModuleConfigurationProvider.addScannerSideProperties(settings, module.definition());
            this.moduleConfiguration = new ModuleConfiguration(globalConfig.getDefinitions(), globalConfig.getEncryption(), settings);
        }
        return this.moduleConfiguration;
    }

    private static void addScannerSideProperties(Map<String, String> settings, ProjectDefinition project) {
        List<ProjectDefinition> orderedProjects = ModuleConfigurationProvider.getTopDownParentProjects(project);
        for (ProjectDefinition p : orderedProjects) {
            settings.putAll(p.properties());
        }
    }

    static List<ProjectDefinition> getTopDownParentProjects(ProjectDefinition project) {
        ArrayList<ProjectDefinition> result = new ArrayList<ProjectDefinition>();
        for (ProjectDefinition p = project; p != null; p = p.getParent()) {
            result.add(0, p);
        }
        return result;
    }
}

