/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin.metrics;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.css.plugin.metrics.CssToken;
import org.sonar.css.plugin.metrics.CssTokenType;
import org.sonar.css.plugin.metrics.Tokenizer;

public class MetricSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(MetricSensor.class);
    private final FileLinesContextFactory fileLinesContextFactory;

    public MetricSensor(FileLinesContextFactory fileLinesContextFactory) {
        this.fileLinesContextFactory = fileLinesContextFactory;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("CSS Metrics").onlyOnLanguage("css");
    }

    public void execute(SensorContext context) {
        FileSystem fileSystem = context.fileSystem();
        Iterable inputFiles = fileSystem.inputFiles(fileSystem.predicates().hasLanguage("css"));
        Tokenizer tokenizer = new Tokenizer();
        for (InputFile file : inputFiles) {
            try {
                List<CssToken> tokenList = tokenizer.tokenize(file.contents());
                MetricSensor.saveHighlights(context, file, tokenList);
                this.saveLineTypes(context, file, tokenList);
            }
            catch (IOException e) {
                LOG.error(String.format("Failed to read file '%s'", file.toString()), (Throwable)e);
            }
        }
    }

    private static void saveHighlights(SensorContext context, InputFile file, List<CssToken> tokenList) {
        NewHighlighting highlighting = context.newHighlighting().onFile(file);
        for (int i = 0; i < tokenList.size(); ++i) {
            CssToken currentToken = tokenList.get(i);
            CssToken nextToken = i + 1 < tokenList.size() ? tokenList.get(i + 1) : null;
            TypeOfText highlightingType = null;
            switch (currentToken.type) {
                case COMMENT: {
                    highlightingType = TypeOfText.COMMENT;
                    break;
                }
                case STRING: {
                    highlightingType = TypeOfText.STRING;
                    break;
                }
                case NUMBER: {
                    highlightingType = TypeOfText.CONSTANT;
                    break;
                }
                case AT_IDENTIFIER: {
                    highlightingType = TypeOfText.ANNOTATION;
                    break;
                }
                case DOLLAR_IDENTIFIER: {
                    highlightingType = TypeOfText.KEYWORD;
                    break;
                }
                case HASH_IDENTIFIER: {
                    if (currentToken.text.matches("^#[0-9a-fA-F]+$")) {
                        highlightingType = TypeOfText.CONSTANT;
                        break;
                    }
                    highlightingType = TypeOfText.KEYWORD;
                    break;
                }
                case IDENTIFIER: {
                    if (nextToken == null || !nextToken.text.equals(":")) break;
                    highlightingType = TypeOfText.KEYWORD_LIGHT;
                    break;
                }
                default: {
                    highlightingType = null;
                }
            }
            if (highlightingType == null) continue;
            highlighting.highlight(currentToken.startLine.intValue(), currentToken.startColumn.intValue(), currentToken.endLine.intValue(), currentToken.endColumn.intValue(), highlightingType);
        }
        highlighting.save();
    }

    private void saveLineTypes(SensorContext context, InputFile file, List<CssToken> tokenList) {
        HashSet<Integer> linesOfCode = new HashSet<Integer>();
        HashSet<Integer> linesOfComment = new HashSet<Integer>();
        for (CssToken token : tokenList) {
            for (int line2 = token.startLine.intValue(); line2 <= token.endLine; ++line2) {
                if (token.type.equals(CssTokenType.COMMENT)) {
                    linesOfComment.add(line2);
                    continue;
                }
                linesOfCode.add(line2);
            }
        }
        context.newMeasure().on((InputComponent)file).forMetric((Metric)CoreMetrics.NCLOC).withValue((Serializable)Integer.valueOf(linesOfCode.size())).save();
        context.newMeasure().on((InputComponent)file).forMetric((Metric)CoreMetrics.COMMENT_LINES).withValue((Serializable)Integer.valueOf(linesOfComment.size())).save();
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(file);
        linesOfCode.forEach(line -> fileLinesContext.setIntValue("ncloc_data", line.intValue(), 1));
        fileLinesContext.save();
    }
}

