/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin.server;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.time.Duration;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.sonar.api.Startable;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.css.plugin.CssRuleSensor;
import org.sonar.css.plugin.server.NetUtils;
import org.sonar.css.plugin.server.NodeDeprecationWarning;
import org.sonar.css.plugin.server.bundle.Bundle;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.nodejs.NodeCommand;
import org.sonarsource.nodejs.NodeCommandBuilder;
import org.sonarsource.nodejs.NodeCommandException;

@ScannerSide
@SonarLintSide(lifespan="MULTIPLE_ANALYSES")
public class CssAnalyzerBridgeServer
implements Startable {
    private static final Logger LOG = Loggers.get(CssAnalyzerBridgeServer.class);
    private static final Profiler PROFILER = Profiler.createIfDebug((Logger)LOG);
    private static final int DEFAULT_TIMEOUT_SECONDS = 60;
    private static final String MAX_OLD_SPACE_SIZE_PROPERTY = "sonar.css.node.maxspace";
    private static final Gson GSON = new Gson();
    private final OkHttpClient client;
    private final NodeCommandBuilder nodeCommandBuilder;
    final int timeoutSeconds;
    private final Bundle bundle;
    private final AnalysisWarnings analysisWarnings;
    private final String hostAddress;
    private int port;
    private NodeCommand nodeCommand;
    private final NodeDeprecationWarning deprecationWarning;
    private boolean failedToStart;

    public CssAnalyzerBridgeServer(Bundle bundle, @Nullable AnalysisWarnings analysisWarnings, NodeDeprecationWarning deprecationWarning) {
        this(NodeCommand.builder(), 60, bundle, analysisWarnings, deprecationWarning);
    }

    protected CssAnalyzerBridgeServer(NodeCommandBuilder nodeCommandBuilder, int timeoutSeconds, Bundle bundle, @Nullable AnalysisWarnings analysisWarnings, NodeDeprecationWarning deprecationWarning) {
        this.nodeCommandBuilder = nodeCommandBuilder;
        this.timeoutSeconds = timeoutSeconds;
        this.bundle = bundle;
        this.analysisWarnings = analysisWarnings;
        this.client = new OkHttpClient.Builder().callTimeout(Duration.ofSeconds(timeoutSeconds)).readTimeout(Duration.ofSeconds(timeoutSeconds)).build();
        this.hostAddress = InetAddress.getLoopbackAddress().getHostAddress();
        this.deprecationWarning = deprecationWarning;
    }

    public void deploy(File deployLocation) {
        this.bundle.deploy(deployLocation.toPath());
    }

    public void startServer(SensorContext context) throws IOException {
        PROFILER.startDebug("Starting server");
        this.port = NetUtils.findOpenPort();
        File scriptFile = new File(this.bundle.startServerScript());
        if (!scriptFile.exists()) {
            throw new NodeCommandException("Node.js script to start css-bundle server doesn't exist: " + scriptFile.getAbsolutePath());
        }
        this.initNodeCommand(context, scriptFile);
        LOG.debug("Starting Node.js process to start css-bundle server at port " + this.port);
        this.nodeCommand.start();
        if (!this.waitServerToStart(this.timeoutSeconds * 1000)) {
            throw new NodeCommandException("Failed to start server (" + this.timeoutSeconds + "s timeout)");
        }
        PROFILER.stopDebug();
        this.deprecationWarning.logNodeDeprecation(this.nodeCommand.getActualNodeVersion());
    }

    boolean waitServerToStart(int timeoutMs) {
        int sleepStep = 100;
        long start = System.currentTimeMillis();
        try {
            Thread.sleep(sleepStep);
            while (!this.isAlive()) {
                if (System.currentTimeMillis() - start > (long)timeoutMs) {
                    return false;
                }
                Thread.sleep(sleepStep);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    private void initNodeCommand(SensorContext context, File scriptFile) throws IOException {
        this.nodeCommandBuilder.outputConsumer(message -> {
            if (message.startsWith("DEBUG")) {
                LOG.debug(message.substring(5).trim());
            } else if (message.startsWith("WARN")) {
                LOG.warn(message.substring(4).trim());
            } else {
                LOG.info(message);
            }
        }).minNodeVersion(10).configuration(context.config()).script(scriptFile.getAbsolutePath()).pathResolver(this.bundle).scriptArgs(String.valueOf(this.port), this.hostAddress);
        context.config().getInt(MAX_OLD_SPACE_SIZE_PROPERTY).ifPresent(this.nodeCommandBuilder::maxOldSpaceSize);
        this.nodeCommand = this.nodeCommandBuilder.build();
    }

    public boolean startServerLazily(SensorContext context) throws IOException {
        if (this.failedToStart) {
            LOG.debug("Skipping start of css-bundle server due to the failure during first analysis");
            LOG.debug("Skipping execution of CSS rules due to the problems with css-bundle server");
            return false;
        }
        try {
            if (this.isAlive()) {
                LOG.debug("css-bundle server is up, no need to start.");
                return true;
            }
            this.deploy(context.fileSystem().workDir());
            this.startServer(context);
            return true;
        }
        catch (NodeCommandException e) {
            this.failedToStart = true;
            this.processNodeCommandException(e, context);
            return false;
        }
    }

    private void processNodeCommandException(NodeCommandException e, SensorContext context) {
        String message = "CSS rules were not executed. " + e.getMessage();
        if (CssRuleSensor.hasCssFiles(context)) {
            LOG.error(message, (Throwable)e);
            this.reportAnalysisWarning(message);
        } else {
            LOG.warn(message);
        }
        CssRuleSensor.throwFailFast(context, e);
    }

    public Issue[] analyze(Request request) throws IOException {
        String json = GSON.toJson(request);
        return CssAnalyzerBridgeServer.parseResponse(this.request(json));
    }

    private String request(String json) throws IOException {
        okhttp3.Request request = new Request.Builder().url(this.url("analyze")).post(RequestBody.create(MediaType.get("application/json"), json)).build();
        try (Response response = this.client.newCall(request).execute();){
            String string = response.body().string();
            return string;
        }
    }

    private static Issue[] parseResponse(String result) {
        try {
            return GSON.fromJson(result, Issue[].class);
        }
        catch (JsonSyntaxException e) {
            String msg = "Failed to parse response: \n-----\n" + result + "\n-----\n";
            LOG.debug(msg);
            throw new IllegalStateException("Failed to parse response (check DEBUG logs for the response content)", e);
        }
    }

    public boolean isAlive() {
        if (this.nodeCommand == null) {
            return false;
        }
        okhttp3.Request request = new Request.Builder().url(this.url("status")).get().build();
        Response response = this.client.newCall(request).execute();
        try {
            String body = response.body().string();
            boolean bl = "OK!".equals(body);
            if (response != null) {
                response.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    public String getCommandInfo() {
        if (this.nodeCommand == null) {
            return "Node.js command to start css-bundle server was not built yet.";
        }
        return "Node.js command to start css-bundle was: " + this.nodeCommand.toString();
    }

    public void start() {
    }

    public void stop() {
        this.clean();
    }

    void clean() {
        if (this.nodeCommand != null) {
            this.callClose();
            this.nodeCommand.waitFor();
            this.nodeCommand = null;
        }
    }

    private void callClose() {
        okhttp3.Request request = new Request.Builder().url(this.url("close")).post(RequestBody.create(MediaType.get("application/json"), "")).build();
        try {
            Response response = this.client.newCall(request).execute();
            if (response != null) {
                response.close();
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to close stylelint-bridge server", (Throwable)e);
        }
    }

    private HttpUrl url(String endpoint) {
        HttpUrl.Builder builder = new HttpUrl.Builder();
        return builder.scheme("http").host(this.hostAddress).port(this.port).addPathSegment(endpoint).build();
    }

    public void setPort(int port) {
        this.port = port;
    }

    private void reportAnalysisWarning(String message) {
        if (this.analysisWarnings != null) {
            this.analysisWarnings.addUnique(message);
        }
    }

    public static class Issue {
        public final Integer line;
        public final String rule;
        public final String text;

        public Issue(Integer line, String rule, String text) {
            this.line = line;
            this.rule = rule;
            this.text = text;
        }
    }

    public static class Request {
        public final String filePath;
        @Nullable
        public final String fileContent;
        public final String configFile;

        public Request(String filePath, @Nullable String fileContent, String configFile) {
            this.filePath = filePath;
            this.fileContent = fileContent;
            this.configFile = configFile;
        }
    }
}

