/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin.server;

import javax.annotation.Nullable;
import org.sonar.api.SonarEdition;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarRuntime;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide(lifespan="MULTIPLE_ANALYSES")
public class NodeDeprecationWarning {
    private static final Logger LOG = Loggers.get(NodeDeprecationWarning.class);
    private static final int MIN_RECOMMENDED_NODE_VERSION = 10;
    private final SonarRuntime sonarRuntime;
    private final AnalysisWarnings analysisWarnings;

    public NodeDeprecationWarning(SonarRuntime sonarRuntime) {
        this(sonarRuntime, null);
    }

    public NodeDeprecationWarning(SonarRuntime sonarRuntime, @Nullable AnalysisWarnings analysisWarnings) {
        this.sonarRuntime = sonarRuntime;
        this.analysisWarnings = analysisWarnings;
    }

    void logNodeDeprecation(int actualNodeVersion) {
        if (actualNodeVersion < 10) {
            String msg = String.format("You are using Node.js version %d, which reached end-of-life. Support for this version will be dropped in future release, please upgrade Node.js to more recent version.", actualNodeVersion);
            LOG.warn(msg);
            if (this.isSonarQube() && this.analysisWarnings != null) {
                this.analysisWarnings.addUnique(msg);
            }
        }
    }

    private boolean isSonarQube() {
        return this.sonarRuntime.getProduct() == SonarProduct.SONARQUBE && this.sonarRuntime.getEdition() != SonarEdition.SONARCLOUD;
    }
}

