/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.WriteableZoneId;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;

public class RollupGroup
extends AbstractDiffable<RollupGroup>
implements ToXContentObject {
    private static final ParseField GROUP_FIELD = new ParseField("group", new String[0]);
    private static final ParseField DATE_INTERVAL_FIELD = new ParseField("interval", new String[0]);
    private static final ParseField DATE_TIMEZONE_FIELD = new ParseField("timezone", new String[0]);
    private List<String> group;
    private Map<String, DateHistogramInterval> dateInterval;
    private Map<String, WriteableZoneId> dateTimezone;
    public static final ConstructingObjectParser<RollupGroup, Void> PARSER = new ConstructingObjectParser("rollup_group", false, a -> new RollupGroup((List)a[0], (Map)a[1], (Map)a[2]));

    public RollupGroup(List<String> group, Map<String, DateHistogramInterval> dateInterval, Map<String, WriteableZoneId> dateTimezone) {
        this.group = group;
        this.dateInterval = dateInterval;
        this.dateTimezone = dateTimezone;
    }

    public RollupGroup() {
        this.group = new ArrayList<String>();
        this.dateInterval = new HashMap<String, DateHistogramInterval>();
        this.dateTimezone = new HashMap<String, WriteableZoneId>();
    }

    public RollupGroup(StreamInput in) throws IOException {
        this.group = in.readStringList();
        this.dateInterval = in.readMap(StreamInput::readString, DateHistogramInterval::new);
        this.dateTimezone = in.readMap(StreamInput::readString, WriteableZoneId::new);
    }

    public static RollupGroup fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public void add(String name, DateHistogramInterval interval, WriteableZoneId timezone) {
        this.group.add(name);
        this.dateInterval.put(name, interval);
        this.dateTimezone.put(name, timezone);
    }

    public void remove(String name) {
        this.group.remove(name);
        this.dateInterval.remove(name);
        this.dateTimezone.remove(name);
    }

    public boolean contains(String name) {
        return this.group.contains(name);
    }

    public DateHistogramInterval getDateInterval(String name) {
        return this.dateInterval.get(name);
    }

    public WriteableZoneId getDateTimezone(String name) {
        return this.dateTimezone.get(name);
    }

    public List<String> getIndices() {
        return this.group;
    }

    static Diff<RollupGroup> readDiffFrom(StreamInput in) throws IOException {
        return AbstractDiffable.readDiffFrom(RollupGroup::new, in);
    }

    public static RollupGroup parse(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.group);
        out.writeMap(this.dateInterval, StreamOutput::writeString, (stream, val) -> val.writeTo(stream));
        out.writeMap(this.dateTimezone, StreamOutput::writeString, (stream, val) -> val.writeTo(stream));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(GROUP_FIELD.getPreferredName(), this.group).field(DATE_INTERVAL_FIELD.getPreferredName(), this.dateInterval).field(DATE_TIMEZONE_FIELD.getPreferredName(), this.dateTimezone).endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RollupGroup that = (RollupGroup)o;
        return this.group.equals(that.group) && this.dateInterval.equals(that.dateInterval) && this.dateTimezone.equals(that.dateTimezone);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.dateInterval, this.dateTimezone);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), GROUP_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            HashMap<String, DateHistogramInterval> intervalMap = new HashMap<String, DateHistogramInterval>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                String name = p.currentName();
                p.nextToken();
                String expression = p.text();
                intervalMap.put(name, new DateHistogramInterval(expression));
            }
            return intervalMap;
        }, DATE_INTERVAL_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            HashMap<String, WriteableZoneId> zoneMap = new HashMap<String, WriteableZoneId>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                String name = p.currentName();
                p.nextToken();
                String timezone = p.text();
                zoneMap.put(name, WriteableZoneId.of(timezone));
            }
            return zoneMap;
        }, DATE_TIMEZONE_FIELD);
    }
}

