/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Assertions;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.ReloadableCustomAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.script.ScriptService;

public class MapperService
extends AbstractIndexComponent
implements Closeable {
    public static final String DEFAULT_MAPPING = "_default_";
    public static final String SINGLE_MAPPING_NAME = "_doc";
    public static final Setting<Long> INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_fields.limit", 50L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_objects.limit", 10000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.total_fields.limit", 1000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_DEPTH_LIMIT_SETTING = Setting.longSetting("index.mapping.depth.limit", 20L, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_FIELD_NAME_LENGTH_LIMIT_SETTING = Setting.longSetting("index.mapping.field_name_length.limit", Long.MAX_VALUE, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final boolean INDEX_MAPPER_DYNAMIC_DEFAULT = true;
    @Deprecated
    public static final Setting<Boolean> INDEX_MAPPER_DYNAMIC_SETTING = Setting.boolSetting("index.mapper.dynamic", true, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.Deprecated);
    @Deprecated
    public static final Set<String> META_FIELDS_BEFORE_7DOT8 = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("_id", "_ignored", "_index", "_routing", "_size", "_timestamp", "_ttl", "_type")));
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(MapperService.class);
    static final String DEFAULT_MAPPING_ERROR_MESSAGE = "[_default_] mappings are not allowed on new indices and should no longer be used. See [https://www.elastic.co/guide/en/elasticsearch/reference/current/breaking-changes-7.0.html#default-mapping-not-allowed] for more information.";
    private final IndexAnalyzers indexAnalyzers;
    private final MappingParser mappingParser;
    private final DocumentParser documentParser;
    private final Version indexVersionCreated;
    private final MapperRegistry mapperRegistry;
    private final Supplier<Mapper.TypeParser.ParserContext> parserContextSupplier;
    private volatile String defaultMappingSource;
    private volatile DocumentMapper mapper;
    private volatile DocumentMapper defaultMapper;

    public MapperService(IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, NamedXContentRegistry xContentRegistry, SimilarityService similarityService, MapperRegistry mapperRegistry, Supplier<SearchExecutionContext> searchExecutionContextSupplier, BooleanSupplier idFieldDataEnabled, ScriptService scriptService) {
        super(indexSettings);
        this.indexVersionCreated = indexSettings.getIndexVersionCreated();
        this.indexAnalyzers = indexAnalyzers;
        this.mapperRegistry = mapperRegistry;
        Function<DateFormatter, Mapper.TypeParser.ParserContext> parserContextFunction = dateFormatter -> new Mapper.TypeParser.ParserContext(similarityService::getSimilarity, mapperRegistry.getMapperParsers()::get, mapperRegistry.getRuntimeFieldTypeParsers()::get, this.indexVersionCreated, searchExecutionContextSupplier, (DateFormatter)dateFormatter, scriptService, indexAnalyzers, indexSettings, idFieldDataEnabled, mapperRegistry.getDynamicRuntimeFieldsBuilder() != null);
        this.documentParser = new DocumentParser(xContentRegistry, parserContextFunction, mapperRegistry.getDynamicRuntimeFieldsBuilder());
        Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = mapperRegistry.getMetadataMapperParsers(indexSettings.getIndexVersionCreated());
        this.parserContextSupplier = () -> (Mapper.TypeParser.ParserContext)parserContextFunction.apply(null);
        this.mappingParser = new MappingParser(this.parserContextSupplier, metadataMapperParsers, this::getMetadataMappers, this::resolveDocumentType, xContentRegistry);
        if (INDEX_MAPPER_DYNAMIC_SETTING.exists(indexSettings.getSettings()) && indexSettings.getIndexVersionCreated().onOrAfter(Version.V_7_0_0)) {
            throw new IllegalArgumentException("Setting " + INDEX_MAPPER_DYNAMIC_SETTING.getKey() + " was removed after version 6.0.0");
        }
        this.defaultMappingSource = "{\"_default_\":{}}";
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("default mapping source[{}]", (Object)this.defaultMappingSource);
        }
    }

    public boolean hasNested() {
        return this.mappingLookup().hasNested();
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.indexAnalyzers;
    }

    public NamedAnalyzer getNamedAnalyzer(String analyzerName) {
        return this.indexAnalyzers.get(analyzerName);
    }

    public Mapper.TypeParser.ParserContext parserContext() {
        return this.parserContextSupplier.get();
    }

    DocumentParser documentParser() {
        return this.documentParser;
    }

    Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> getMetadataMappers(String type) {
        DocumentMapper existingMapper = this.documentMapper(type);
        Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = this.mapperRegistry.getMetadataMapperParsers(this.indexSettings.getIndexVersionCreated());
        LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = new LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>();
        if (existingMapper == null) {
            for (MetadataFieldMapper.TypeParser parser : metadataMapperParsers.values()) {
                MetadataFieldMapper metadataFieldMapper = parser.getDefault(this.parserContext());
                metadataMappers.put(metadataFieldMapper.getClass(), metadataFieldMapper);
            }
        } else {
            metadataMappers.putAll(existingMapper.mapping().metadataMappersMap);
        }
        return metadataMappers;
    }

    public static Map<String, Object> parseMapping(NamedXContentRegistry xContentRegistry, String mappingSource) throws IOException {
        try (XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mappingSource);){
            Map<String, Object> map = parser.map();
            return map;
        }
    }

    public void updateMapping(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) throws IOException {
        Map<String, DocumentMapper> updatedEntries;
        MappingMetadata mappingMetadata;
        assert (newIndexMetadata.getIndex().equals(this.index())) : "index mismatch: expected " + this.index() + " but was " + newIndexMetadata.getIndex();
        if (currentIndexMetadata != null && currentIndexMetadata.getMappingVersion() == newIndexMetadata.getMappingVersion()) {
            this.assertMappingVersion(currentIndexMetadata, newIndexMetadata, Collections.emptyMap());
            return;
        }
        HashSet<String> existingMappers = new HashSet<String>();
        if (this.mapper != null) {
            existingMappers.add(this.mapper.type());
        }
        if (this.defaultMapper != null) {
            existingMappers.add(DEFAULT_MAPPING);
        }
        try {
            LinkedHashMap<String, CompressedXContent> map = new LinkedHashMap<String, CompressedXContent>();
            for (ObjectCursor cursor : newIndexMetadata.getMappings().values()) {
                mappingMetadata = (MappingMetadata)cursor.value;
                map.put(mappingMetadata.type(), mappingMetadata.source());
            }
            Mappings mappings = this.parseMappings(map, MergeReason.MAPPING_RECOVERY);
            assert (this.assertRefreshIsNotNeeded(this.mapper, mappings));
            updatedEntries = this.applyMappings(mappings, () -> ((CompressedXContent)map.get(DEFAULT_MAPPING)).string(), MergeReason.MAPPING_RECOVERY);
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("[{}] failed to apply mappings", (Object)this.index()), (Throwable)e);
            throw e;
        }
        for (DocumentMapper documentMapper : updatedEntries.values()) {
            String op;
            String mappingType = documentMapper.type();
            if (mappingType.equals(DEFAULT_MAPPING)) {
                mappingMetadata = newIndexMetadata.defaultMapping();
            } else {
                mappingMetadata = newIndexMetadata.mapping();
                assert (mappingType.equals(mappingMetadata.type()));
            }
            CompressedXContent incomingMappingSource = mappingMetadata.source();
            String string = op = existingMappers.contains(mappingType) ? "updated" : "added";
            if (this.logger.isDebugEnabled() && incomingMappingSource.compressed().length < 512) {
                this.logger.debug("[{}] {} mapping [{}], source [{}]", (Object)this.index(), (Object)op, (Object)mappingType, (Object)incomingMappingSource.string());
                continue;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] {} mapping [{}], source [{}]", (Object)this.index(), (Object)op, (Object)mappingType, (Object)incomingMappingSource.string());
                continue;
            }
            this.logger.debug("[{}] {} mapping [{}] (source suppressed due to length, use TRACE level if needed)", (Object)this.index(), (Object)op, (Object)mappingType);
        }
    }

    private boolean assertRefreshIsNotNeeded(DocumentMapper currentMapper, Mappings mappings) {
        Mappings mergedMappings = this.mergeMappings(currentMapper, mappings, MergeReason.MAPPING_RECOVERY);
        if (mergedMappings.defaultMapping != null) {
            this.assertRefreshIsNotNeeded(mergedMappings.defaultMapping, DEFAULT_MAPPING, mappings.defaultMapping);
        }
        if (mergedMappings.incomingMapping != null) {
            String type = mergedMappings.incomingMapping.root().name();
            this.assertRefreshIsNotNeeded(mergedMappings.incomingMapping, type, mappings.incomingMapping);
        }
        return true;
    }

    private void assertRefreshIsNotNeeded(Mapping mergedMapping, String type, Mapping incomingMapping) {
        CompressedXContent incomingMappingSource;
        CompressedXContent mergedMappingSource;
        ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("skip_runtime", "true"));
        try {
            mergedMappingSource = new CompressedXContent(mergedMapping, XContentType.JSON, params);
        }
        catch (Exception e) {
            throw new AssertionError("failed to serialize source for type [" + type + "]", e);
        }
        try {
            incomingMappingSource = new CompressedXContent(incomingMapping, XContentType.JSON, params);
        }
        catch (Exception e) {
            throw new AssertionError("failed to serialize source for type [" + type + "]", e);
        }
        assert (mergedMappingSource.equals(incomingMappingSource)) : "[" + this.index() + "] parsed mapping, and got different sources\nincoming:\n" + incomingMappingSource + "\nmerged:\n" + mergedMappingSource;
    }

    private void assertMappingVersion(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata, Map<String, DocumentMapper> updatedEntries) {
        if (Assertions.ENABLED && currentIndexMetadata != null && currentIndexMetadata.getCreationVersion().onOrAfter(Version.V_6_5_0)) {
            if (currentIndexMetadata.getMappingVersion() == newIndexMetadata.getMappingVersion()) {
                MappingMetadata mapping;
                assert (updatedEntries.isEmpty()) : updatedEntries;
                MappingMetadata defaultMapping = newIndexMetadata.defaultMapping();
                if (defaultMapping != null) {
                    CompressedXContent currentSource = currentIndexMetadata.defaultMapping().source();
                    CompressedXContent newSource = defaultMapping.source();
                    assert (currentSource.equals(newSource)) : "expected current mapping [" + currentSource + "] for type [" + defaultMapping.type() + "] to be the same as new mapping [" + newSource + "]";
                }
                if ((mapping = newIndexMetadata.mapping()) != null) {
                    CompressedXContent currentSource = currentIndexMetadata.mapping().source();
                    CompressedXContent newSource = mapping.source();
                    assert (currentSource.equals(newSource)) : "expected current mapping [" + currentSource + "] for type [" + mapping.type() + "] to be the same as new mapping [" + newSource + "]";
                    assert (currentSource.equals(this.mapper.mappingSource())) : "expected current mapping [" + currentSource + "] for type [" + mapping.type() + "] to be the same as new mapping [" + this.mapper.mappingSource() + "]";
                }
            } else {
                long currentMappingVersion = currentIndexMetadata.getMappingVersion();
                long newMappingVersion = newIndexMetadata.getMappingVersion();
                assert (currentMappingVersion < newMappingVersion) : "expected current mapping version [" + currentMappingVersion + "] to be less than new mapping version [" + newMappingVersion + "]";
                assert (!updatedEntries.isEmpty());
                for (DocumentMapper documentMapper : updatedEntries.values()) {
                    MappingMetadata currentMapping;
                    if (documentMapper.type().equals(DEFAULT_MAPPING)) {
                        currentMapping = currentIndexMetadata.defaultMapping();
                    } else {
                        currentMapping = currentIndexMetadata.mapping();
                        assert (currentMapping == null || documentMapper.type().equals(currentMapping.type()));
                    }
                    if (currentMapping == null) continue;
                    CompressedXContent currentSource = currentMapping.source();
                    CompressedXContent newSource = documentMapper.mappingSource();
                    assert (!currentSource.equals(newSource)) : "expected current mapping [" + currentSource + "] for type [" + documentMapper.type() + "] to be different than new mapping";
                }
            }
        }
    }

    public void merge(Map<String, Map<String, Object>> mappings, MergeReason reason) {
        LinkedHashMap<String, CompressedXContent> mappingSourcesCompressed = new LinkedHashMap<String, CompressedXContent>(mappings.size());
        for (Map.Entry<String, Map<String, Object>> entry : mappings.entrySet()) {
            try {
                mappingSourcesCompressed.put(entry.getKey(), new CompressedXContent(Strings.toString(XContentFactory.jsonBuilder().map(entry.getValue()))));
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
            }
        }
        this.mergeAndApplyMappings(mappingSourcesCompressed, reason);
    }

    public void merge(String type, Map<String, Object> mappings, MergeReason reason) throws IOException {
        CompressedXContent content = new CompressedXContent(Strings.toString(XContentFactory.jsonBuilder().map(mappings)));
        this.mergeAndApplyMappings(Collections.singletonMap(type, content), reason);
    }

    public void merge(IndexMetadata indexMetadata, MergeReason reason) {
        assert (reason != MergeReason.MAPPING_UPDATE_PREFLIGHT);
        LinkedHashMap<String, CompressedXContent> map = new LinkedHashMap<String, CompressedXContent>();
        for (ObjectCursor cursor : indexMetadata.getMappings().values()) {
            MappingMetadata mappingMetadata = (MappingMetadata)cursor.value;
            map.put(mappingMetadata.type(), mappingMetadata.source());
        }
        this.mergeAndApplyMappings(map, reason);
    }

    public DocumentMapper merge(String type, CompressedXContent mappingSource, MergeReason reason) {
        return this.mergeAndApplyMappings(Collections.singletonMap(type, mappingSource), reason).get(type);
    }

    private synchronized Map<String, DocumentMapper> mergeAndApplyMappings(Map<String, CompressedXContent> mappings, MergeReason reason) {
        Mappings parsedMappings = this.parseMappings(mappings, reason);
        Mappings mergedMappings = this.mergeMappings(this.mapper, parsedMappings, reason);
        return this.applyMappings(mergedMappings, () -> ((CompressedXContent)mappings.get(DEFAULT_MAPPING)).string(), reason);
    }

    private synchronized Map<String, DocumentMapper> applyMappings(Mappings mergedMappings, Supplier<String> defaultMappingSourceSupplier, MergeReason reason) {
        DocumentMapper newDocumentMapper;
        String newDefaultMappingSource = null;
        DocumentMapper newDefaultMapper = null;
        DocumentMapper newMapper = null;
        LinkedHashMap<String, DocumentMapper> documentMappers = new LinkedHashMap<String, DocumentMapper>();
        if (mergedMappings.defaultMapping != null) {
            newDocumentMapper = this.newDocumentMapper(mergedMappings.defaultMapping, reason);
            newDefaultMappingSource = defaultMappingSourceSupplier.get();
            newDefaultMapper = newDocumentMapper;
            documentMappers.put(DEFAULT_MAPPING, newDocumentMapper);
        }
        if (mergedMappings.incomingMapping != null) {
            newMapper = newDocumentMapper = this.newDocumentMapper(mergedMappings.incomingMapping, reason);
            documentMappers.put(newDocumentMapper.type(), newDocumentMapper);
        }
        if (reason == MergeReason.MAPPING_UPDATE_PREFLIGHT) {
            return documentMappers;
        }
        if (newDefaultMappingSource != null) {
            this.defaultMappingSource = newDefaultMappingSource;
            this.defaultMapper = newDefaultMapper;
        }
        if (newMapper != null) {
            this.mapper = newMapper;
        }
        assert (documentMappers.values().stream().allMatch(this::assertSerialization));
        return documentMappers;
    }

    private DocumentMapper newDocumentMapper(Mapping mapping, MergeReason reason) {
        DocumentMapper newMapper = new DocumentMapper(this.indexSettings, this.indexAnalyzers, this.documentParser, mapping);
        newMapper.root().fixRedundantIncludes();
        newMapper.validate(this.indexSettings, reason != MergeReason.MAPPING_RECOVERY);
        return newMapper;
    }

    private Mappings parseMappings(Map<String, CompressedXContent> mappings, MergeReason reason) {
        Mapping defaultMapping = null;
        String defaultMappingSource = null;
        if (mappings.containsKey(DEFAULT_MAPPING)) {
            try {
                defaultMapping = this.mappingParser.parse(DEFAULT_MAPPING, mappings.get(DEFAULT_MAPPING));
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, DEFAULT_MAPPING, e.getMessage());
            }
            defaultMappingSource = mappings.get(DEFAULT_MAPPING).string();
        }
        String defaultMappingSourceOrLastStored = defaultMappingSource != null ? defaultMappingSource : this.defaultMappingSource;
        Mapping incomingMapping = null;
        for (Map.Entry<String, CompressedXContent> entry : mappings.entrySet()) {
            String type = entry.getKey();
            if (type.equals(DEFAULT_MAPPING)) continue;
            if (incomingMapping != null) {
                throw new IllegalArgumentException("Cannot put multiple mappings: " + mappings.keySet());
            }
            boolean applyDefault = reason != MergeReason.MAPPING_RECOVERY && this.mapper == null;
            try {
                incomingMapping = this.mappingParser.parse(type, entry.getValue(), applyDefault ? defaultMappingSourceOrLastStored : null);
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
            }
        }
        return new Mappings(defaultMapping, incomingMapping);
    }

    public Mapping parseMapping(String type, CompressedXContent mappingSource, boolean applyDefault) {
        try {
            return this.mappingParser.parse(type, mappingSource, applyDefault ? this.defaultMappingSource : null);
        }
        catch (Exception e) {
            throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, type, e.getMessage());
        }
    }

    private Mappings mergeMappings(DocumentMapper currentMapper, Mappings mappings, MergeReason reason) {
        Mapping defaultMapping = mappings.defaultMapping;
        if (defaultMapping != null) {
            if (this.indexSettings.getIndexVersionCreated().onOrAfter(Version.V_7_0_0)) {
                throw new IllegalArgumentException(DEFAULT_MAPPING_ERROR_MESSAGE);
            }
            if (reason == MergeReason.MAPPING_UPDATE) {
                deprecationLogger.deprecate(DeprecationCategory.MAPPINGS, "default_mapping_not_allowed", DEFAULT_MAPPING_ERROR_MESSAGE, new Object[0]);
            }
            assert (defaultMapping.root().name().equals(DEFAULT_MAPPING));
        }
        Mapping incomingMapping = mappings.incomingMapping;
        Mapping newMapping = null;
        if (incomingMapping != null) {
            MapperService.validateTypeName(incomingMapping.root().name());
            newMapping = MapperService.mergeMappings(currentMapper, incomingMapping, reason);
        }
        return new Mappings(defaultMapping, newMapping);
    }

    public static Mapping mergeMappings(DocumentMapper currentMapper, Mapping incomingMapping, MergeReason reason) {
        Mapping newMapping = currentMapper == null ? incomingMapping : currentMapper.mapping().merge(incomingMapping, reason);
        return newMapping;
    }

    private boolean assertSerialization(DocumentMapper mapper) {
        CompressedXContent mappingSource = mapper.mappingSource();
        DocumentMapper newMapper = this.parse(mapper.type(), mappingSource, false);
        if (!newMapper.mappingSource().equals(mappingSource)) {
            throw new IllegalStateException("DocumentMapper serialization result is different from source. \n--> Source [" + mappingSource + "]\n--> Result [" + newMapper.mappingSource() + "]");
        }
        return true;
    }

    static void validateTypeName(String type) {
        if (type.length() == 0) {
            throw new InvalidTypeNameException("mapping type name is empty");
        }
        if (type.length() > 255) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] is too long; limit is length 255 but was [" + type.length() + "]");
        }
        if (type.charAt(0) == '_' && !SINGLE_MAPPING_NAME.equals(type)) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] can't start with '_' unless it is called [" + SINGLE_MAPPING_NAME + "]");
        }
        if (type.contains("#")) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] should not include '#' in it");
        }
        if (type.contains(",")) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] should not include ',' in it");
        }
        if (type.charAt(0) == '.') {
            throw new IllegalArgumentException("mapping type name [" + type + "] must not start with a '.'");
        }
    }

    public DocumentMapper parse(String mappingType, CompressedXContent mappingSource, boolean applyDefault) throws MapperParsingException {
        Mapping mapping = this.mappingParser.parse(mappingType, mappingSource, applyDefault ? this.defaultMappingSource : null);
        return new DocumentMapper(this.indexSettings, this.indexAnalyzers, this.documentParser, mapping);
    }

    public DocumentMapper documentMapper() {
        return this.mapper;
    }

    public DocumentMapper documentMapper(String type) {
        if (this.mapper != null && type.equals(this.mapper.type())) {
            return this.mapper;
        }
        if (DEFAULT_MAPPING.equals(type)) {
            return this.defaultMapper;
        }
        return null;
    }

    public static boolean isMappingSourceTyped(String type, Map<String, Object> mapping) {
        return mapping.size() == 1 && mapping.keySet().iterator().next().equals(type);
    }

    public static boolean isMappingSourceTyped(String type, CompressedXContent mappingSource) {
        Map<String, Object> root = XContentHelper.convertToMap(mappingSource.compressedReference(), true, XContentType.JSON).v2();
        return MapperService.isMappingSourceTyped(type, root);
    }

    public String getTypeForUpdate(String type, CompressedXContent mappingSource) {
        return !MapperService.isMappingSourceTyped(type, mappingSource) ? this.resolveDocumentType(type) : type;
    }

    public String resolveDocumentType(String type) {
        if (SINGLE_MAPPING_NAME.equals(type) && this.mapper != null) {
            return this.mapper.type();
        }
        return type;
    }

    public DocumentMapperForType documentMapperWithAutoCreate(String type) {
        DocumentMapper mapper = this.documentMapper(type);
        if (mapper != null) {
            return new DocumentMapperForType(mapper, null);
        }
        mapper = this.parse(type, null, true);
        return new DocumentMapperForType(mapper, mapper.mapping());
    }

    public MappedFieldType fieldType(String fullName) {
        return this.mappingLookup().fieldTypesLookup().get(fullName);
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        return this.mappingLookup().simpleMatchToFullName(pattern);
    }

    public MappingLookup mappingLookup() {
        DocumentMapper mapper = this.mapper;
        return mapper == null ? MappingLookup.EMPTY : mapper.mappers();
    }

    public Iterable<MappedFieldType> getEagerGlobalOrdinalsFields() {
        return this.mapper == null ? Collections.emptySet() : this.mapper.mappers().fieldTypesLookup().filter(MappedFieldType::eagerGlobalOrdinals);
    }

    public NamedAnalyzer indexAnalyzer(String field, Function<String, NamedAnalyzer> unindexedFieldAnalyzer) {
        return this.mappingLookup().indexAnalyzer(field, unindexedFieldAnalyzer);
    }

    @Override
    public void close() throws IOException {
        this.indexAnalyzers.close();
    }

    public boolean isMetadataField(String field) {
        return this.mapperRegistry.getMetadataMapperParsers(this.indexVersionCreated).containsKey(field);
    }

    public synchronized List<String> reloadSearchAnalyzers(AnalysisRegistry registry) throws IOException {
        this.logger.info("reloading search analyzers");
        Map<String, TokenizerFactory> tokenizerFactories = registry.buildTokenizerFactories(this.indexSettings);
        Map<String, CharFilterFactory> charFilterFactories = registry.buildCharFilterFactories(this.indexSettings);
        Map<String, TokenFilterFactory> tokenFilterFactories = registry.buildTokenFilterFactories(this.indexSettings);
        Map<String, Settings> settings = this.indexSettings.getSettings().getGroups("index.analysis.analyzer");
        ArrayList<String> reloadedAnalyzers = new ArrayList<String>();
        for (NamedAnalyzer namedAnalyzer : this.indexAnalyzers.getAnalyzers().values()) {
            if (!(namedAnalyzer.analyzer() instanceof ReloadableCustomAnalyzer)) continue;
            ReloadableCustomAnalyzer analyzer = (ReloadableCustomAnalyzer)namedAnalyzer.analyzer();
            String analyzerName = namedAnalyzer.name();
            Settings analyzerSettings = settings.get(analyzerName);
            analyzer.reload(analyzerName, analyzerSettings, tokenizerFactories, charFilterFactories, tokenFilterFactories);
            reloadedAnalyzers.add(analyzerName);
        }
        return reloadedAnalyzers;
    }

    public static enum MergeReason {
        MAPPING_UPDATE_PREFLIGHT,
        MAPPING_UPDATE,
        INDEX_TEMPLATE,
        MAPPING_RECOVERY;

    }

    private static class Mappings {
        private final Mapping defaultMapping;
        private final Mapping incomingMapping;

        Mappings(Mapping defaultMapping, Mapping incomingMapping) {
            this.defaultMapping = defaultMapping;
            this.incomingMapping = incomingMapping;
        }
    }
}

