/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.transport.Transports;

public class MultiFileWriter
extends AbstractRefCounted
implements Releasable {
    private final Runnable ensureOpen;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Logger logger;
    private final Store store;
    private final RecoveryState.Index indexState;
    private final String tempFilePrefix;
    private final ConcurrentMap<String, IndexOutput> openIndexOutputs = ConcurrentCollections.newConcurrentMap();
    private final ConcurrentMap<String, FileChunkWriter> fileChunkWriters = ConcurrentCollections.newConcurrentMap();
    final Map<String, String> tempFileNames = ConcurrentCollections.newConcurrentMap();

    public MultiFileWriter(Store store, RecoveryState.Index indexState, String tempFilePrefix, Logger logger, Runnable ensureOpen) {
        super("multi_file_writer");
        this.store = store;
        this.indexState = indexState;
        this.tempFilePrefix = tempFilePrefix;
        this.logger = logger;
        this.ensureOpen = ensureOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFileChunk(StoreFileMetadata fileMetadata, long position, ReleasableBytesReference content, boolean lastChunk) throws IOException {
        assert (Transports.assertNotTransportThread("multi_file_writer"));
        FileChunkWriter writer = this.fileChunkWriters.computeIfAbsent(fileMetadata.name(), name -> new FileChunkWriter());
        this.incRef();
        try {
            writer.writeChunk(new FileChunk(fileMetadata, content, position, lastChunk));
        }
        finally {
            this.decRef();
        }
    }

    String getTempNameForFile(String origFile) {
        return this.tempFilePrefix + origFile;
    }

    public IndexOutput getOpenIndexOutput(String key) {
        this.ensureOpen.run();
        return (IndexOutput)this.openIndexOutputs.get(key);
    }

    public IndexOutput removeOpenIndexOutputs(String name) {
        this.ensureOpen.run();
        return (IndexOutput)this.openIndexOutputs.remove(name);
    }

    public IndexOutput openAndPutIndexOutput(String fileName, StoreFileMetadata metadata, Store store) throws IOException {
        this.ensureOpen.run();
        String tempFileName = this.getTempNameForFile(fileName);
        if (this.tempFileNames.containsKey(tempFileName)) {
            throw new IllegalStateException("output for file [" + fileName + "] has already been created");
        }
        this.tempFileNames.put(tempFileName, fileName);
        IndexOutput indexOutput = store.createVerifyingOutput(tempFileName, metadata, IOContext.DEFAULT);
        this.openIndexOutputs.put(fileName, indexOutput);
        return indexOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerWriteFileChunk(StoreFileMetadata fileMetadata, long position, BytesReference content, boolean lastChunk) throws IOException {
        BytesRef scratch;
        String name = fileMetadata.name();
        IndexOutput indexOutput = position == 0L ? this.openAndPutIndexOutput(name, fileMetadata, this.store) : this.getOpenIndexOutput(name);
        assert (indexOutput.getFilePointer() == position) : "file-pointer " + indexOutput.getFilePointer() + " != " + position;
        BytesRefIterator iterator = content.iterator();
        while ((scratch = iterator.next()) != null) {
            indexOutput.writeBytes(scratch.bytes, scratch.offset, scratch.length);
        }
        this.indexState.addRecoveredBytesToFile(name, content.length());
        if (indexOutput.getFilePointer() >= fileMetadata.length() || lastChunk) {
            try {
                Store.verify(indexOutput);
            }
            finally {
                indexOutput.close();
            }
            String temporaryFileName = this.getTempNameForFile(name);
            assert (Arrays.asList(this.store.directory().listAll()).contains(temporaryFileName)) : "expected: [" + temporaryFileName + "] in " + Arrays.toString(this.store.directory().listAll());
            this.store.directory().sync(Collections.singleton(temporaryFileName));
            IndexOutput remove = this.removeOpenIndexOutputs(name);
            assert (remove == null || remove == indexOutput);
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.decRef();
        }
    }

    @Override
    protected void closeInternal() {
        Releasables.close(this.fileChunkWriters.values());
        this.fileChunkWriters.clear();
        Iterator iterator = this.openIndexOutputs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.logger.trace("closing IndexOutput file [{}]", entry.getValue());
            try {
                ((IndexOutput)entry.getValue()).close();
            }
            catch (Exception e) {
                this.logger.debug(() -> new ParameterizedMessage("error while closing recovery output [{}]", entry.getValue()), (Throwable)e);
            }
            iterator.remove();
        }
        if (Strings.hasText(this.tempFilePrefix)) {
            for (String file : this.tempFileNames.keySet()) {
                this.logger.trace("cleaning temporary file [{}]", (Object)file);
                this.store.deleteQuiet(file);
            }
        }
    }

    public void renameAllTempFiles() throws IOException {
        this.ensureOpen.run();
        this.store.renameTempFilesSafe(this.tempFileNames);
    }

    private final class FileChunkWriter
    implements Releasable {
        final PriorityQueue<FileChunk> pendingChunks = new PriorityQueue<FileChunk>(Comparator.comparing(fc -> fc.position));
        long lastPosition = 0L;

        private FileChunkWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeChunk(FileChunk newChunk) throws IOException {
            FileChunkWriter fileChunkWriter = this;
            synchronized (fileChunkWriter) {
                this.pendingChunks.add(newChunk);
            }
            while (true) {
                FileChunk chunk;
                FileChunkWriter fileChunkWriter2 = this;
                synchronized (fileChunkWriter2) {
                    chunk = this.pendingChunks.peek();
                    if (chunk == null || chunk.position != this.lastPosition) {
                        return;
                    }
                    this.pendingChunks.remove();
                }
                FileChunk ignored = chunk;
                try {
                    MultiFileWriter.this.innerWriteFileChunk(chunk.md, chunk.position, chunk.content, chunk.lastChunk);
                    FileChunkWriter fileChunkWriter3 = this;
                    synchronized (fileChunkWriter3) {
                        assert (this.lastPosition == chunk.position) : "last_position " + this.lastPosition + " != chunk_position " + chunk.position;
                        this.lastPosition += (long)chunk.content.length();
                        if (chunk.lastChunk) {
                            assert (this.pendingChunks.isEmpty()) : "still have pending chunks [" + this.pendingChunks + "]";
                            MultiFileWriter.this.fileChunkWriters.remove(chunk.md.name());
                            assert (!MultiFileWriter.this.fileChunkWriters.containsValue(this)) : "chunk writer [" + newChunk.md + "] was not removed";
                        }
                        continue;
                    }
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                    continue;
                }
                break;
            }
        }

        @Override
        public synchronized void close() {
            Releasables.close(this.pendingChunks);
        }
    }

    private static final class FileChunk
    implements Releasable {
        final StoreFileMetadata md;
        final ReleasableBytesReference content;
        final long position;
        final boolean lastChunk;

        FileChunk(StoreFileMetadata md, ReleasableBytesReference content, long position, boolean lastChunk) {
            this.md = md;
            this.content = content.retain();
            this.position = position;
            this.lastChunk = lastChunk;
        }

        @Override
        public void close() {
            this.content.decRef();
        }
    }
}

