/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.Map;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.SearchExecutionContext;

public abstract class ConstantFieldType
extends MappedFieldType {
    public ConstantFieldType(String name, Map<String, String> meta) {
        super(name, true, false, true, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
    }

    @Override
    public final boolean isSearchable() {
        return true;
    }

    @Override
    public final boolean isAggregatable() {
        return true;
    }

    protected abstract boolean matches(String var1, boolean var2, SearchExecutionContext var3);

    private static String valueToString(Object value) {
        return value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
    }

    @Override
    public final Query termQuery(Object value, SearchExecutionContext context) {
        String pattern = ConstantFieldType.valueToString(value);
        if (this.matches(pattern, false, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query termQueryCaseInsensitive(Object value, SearchExecutionContext context) {
        String pattern = ConstantFieldType.valueToString(value);
        if (this.matches(pattern, true, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query termsQuery(Collection<?> values, SearchExecutionContext context) {
        for (Object value : values) {
            String pattern = ConstantFieldType.valueToString(value);
            if (!this.matches(pattern, false, context)) continue;
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query prefixQuery(String prefix, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
        String pattern = prefix + "*";
        if (this.matches(pattern, caseInsensitive, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
        if (this.matches(value, caseInsensitive, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }
}

