/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.List;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestUpgradeActionDeprecated
extends BaseRestHandler {
    public static final String UPGRADE_API_DEPRECATION_MESSAGE = "The _upgrade API is no longer useful and will be removed. Instead, see _reindex API.";

    @Override
    public java.util.List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return List.of((Object)new RestHandler.DeprecatedRoute(RestRequest.Method.POST, "/_upgrade", UPGRADE_API_DEPRECATION_MESSAGE), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.POST, "/{index}/_upgrade", UPGRADE_API_DEPRECATION_MESSAGE));
    }

    @Override
    public java.util.List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return "upgrade_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        UpgradeRequest upgradeReq = new UpgradeRequest(Strings.splitStringByCommaToArray(request.param("index")));
        upgradeReq.indicesOptions(IndicesOptions.fromRequest(request, upgradeReq.indicesOptions()));
        upgradeReq.upgradeOnlyAncientSegments(request.paramAsBoolean("only_ancient_segments", false));
        return channel -> client.admin().indices().upgrade(upgradeReq, new RestToXContentListener<UpgradeResponse>((RestChannel)channel));
    }
}

