/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public abstract class AbstractBadFieldNameChecker
extends IssuableSubscriptionVisitor {
    protected static final String DEFAULT_FORMAT_KEY = "format";
    protected static final String DEFAULT_FORMAT_DESCRIPTION = "Regular expression used to check the field names against.";
    protected static final String DEFAULT_FORMAT_VALUE = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM);
    }

    @Override
    public void setContext(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.getFormat(), 32);
        }
        super.setContext(context);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        for (Tree member : classTree.members()) {
            VariableTree field;
            if (!member.is(Tree.Kind.VARIABLE) || !this.isFieldModifierConcernedByRule((field = (VariableTree)member).modifiers()) || this.pattern.matcher(field.simpleName().name()).matches()) continue;
            this.reportIssue(field.simpleName(), String.format("Rename this field \"%s\" to match the regular expression '%s'.", field.simpleName().name(), this.getFormat()));
        }
    }

    protected abstract String getFormat();

    protected abstract boolean isFieldModifierConcernedByRule(ModifiersTree var1);
}

