/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.collections.SetUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractPrintfChecker
extends AbstractMethodDetection {
    private static final Set<String> TIME_CONVERSIONS = SetUtils.immutableSetOf("H", "I", "k", "l", "M", "S", "L", "N", "p", "z", "Z", "s", "Q", "B", "b", "h", "A", "a", "C", "Y", "y", "j", "m", "d", "e", "R", "T", "r", "D", "F", "c");
    protected static final String JAVA_LANG_STRING = "java.lang.String";
    protected static final String JAVA_LANG_THROWABLE = "java.lang.Throwable";
    protected static final String ORG_APACHE_LOGGING_LOG4J_LOGGER = "org.apache.logging.log4j.Logger";
    private static final Pattern PRINTF_PARAM_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    protected static final String PRINTF_METHOD_NAME = "printf";
    private static final String FORMAT_METHOD_NAME = "format";
    protected static final Set<String> LEVELS = SetUtils.immutableSetOf("debug", "error", "info", "trace", "warn", "fatal");
    protected static final MethodMatchers MESSAGE_FORMAT = MethodMatchers.create().ofTypes("java.text.MessageFormat").names("format").withAnyParameters().build();
    protected static final Pattern MESSAGE_FORMAT_PATTERN = Pattern.compile("\\{(?<index>\\d+)(?<type>,\\w+)?(?<style>,[^}]*)?\\}");

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofTypes(JAVA_LANG_STRING).names(FORMAT_METHOD_NAME).withAnyParameters().build(), MethodMatchers.create().ofTypes("java.util.Formatter").names(FORMAT_METHOD_NAME).withAnyParameters().build(), MethodMatchers.create().ofTypes("java.io.PrintStream").names(FORMAT_METHOD_NAME, PRINTF_METHOD_NAME).withAnyParameters().build(), MethodMatchers.create().ofTypes("java.io.PrintWriter").names(FORMAT_METHOD_NAME, PRINTF_METHOD_NAME).withAnyParameters().build(), MESSAGE_FORMAT);
    }

    protected final void checkFormatting(MethodInvocationTree mit, boolean isMessageFormat) {
        List<ExpressionTree> args;
        ExpressionTree formatTree;
        Arguments arguments = mit.arguments();
        if (arguments.stream().map(ExpressionTree::symbolType).anyMatch(Type::isUnknown)) {
            return;
        }
        if (((ExpressionTree)arguments.get(0)).symbolType().is(JAVA_LANG_STRING)) {
            formatTree = (ExpressionTree)arguments.get(0);
            args = arguments.subList(1, arguments.size());
        } else {
            if (arguments.size() < 2) {
                return;
            }
            formatTree = (ExpressionTree)arguments.get(1);
            args = arguments.subList(2, arguments.size());
        }
        if (formatTree.is(Tree.Kind.STRING_LITERAL)) {
            String formatString = LiteralUtils.trimQuotes(((LiteralTree)formatTree).value());
            if (isMessageFormat && AbstractPrintfChecker.isProbablyLog4jFormatterLogger(mit, formatString)) {
                this.handlePrintfFormatCatchingErrors(mit, formatString, args);
                return;
            }
            if (isMessageFormat) {
                this.handleMessageFormat(mit, formatString, args);
            } else {
                AbstractPrintfChecker.transposeArgumentArray(args).ifPresent(transposedArgs -> this.handlePrintfFormat(mit, formatString, (List<ExpressionTree>)transposedArgs));
            }
        } else {
            this.handleOtherFormatTree(mit, formatTree, args);
        }
    }

    protected static Optional<List<ExpressionTree>> transposeArgumentArray(List<ExpressionTree> args) {
        ExpressionTree firstArg;
        if (args.size() == 1 && (firstArg = args.get(0)).symbolType().isArray()) {
            if (AbstractPrintfChecker.isNewArrayWithInitializers(firstArg)) {
                args = ((NewArrayTree)firstArg).initializers();
            } else {
                return Optional.empty();
            }
        }
        return Optional.of(args);
    }

    private static boolean isProbablyLog4jFormatterLogger(MethodInvocationTree mit, String formatString) {
        return mit.symbol().owner().type().is(ORG_APACHE_LOGGING_LOG4J_LOGGER) && !formatString.contains("{}") && formatString.contains("%");
    }

    protected abstract void handlePrintfFormat(MethodInvocationTree var1, String var2, List<ExpressionTree> var3);

    protected abstract void handlePrintfFormatCatchingErrors(MethodInvocationTree var1, String var2, List<ExpressionTree> var3);

    protected abstract void handleMessageFormat(MethodInvocationTree var1, String var2, List<ExpressionTree> var3);

    protected abstract void handleOtherFormatTree(MethodInvocationTree var1, ExpressionTree var2, List<ExpressionTree> var3);

    protected static boolean isNewArrayWithInitializers(ExpressionTree expression) {
        return expression.is(Tree.Kind.NEW_ARRAY) && ((NewArrayTree)expression).openBraceToken() != null;
    }

    protected static String cleanupDoubleQuote(String formatString) {
        return formatString.replace("''", "");
    }

    protected static Set<Integer> getMessageFormatIndexes(String formatString, MethodInvocationTree mit) {
        if (LEVELS.contains(mit.symbol().name()) || formatString.contains("{}")) {
            return IntStream.range(0, StringUtils.countMatches(formatString, "{}")).boxed().collect(Collectors.toSet());
        }
        Matcher matcher = MESSAGE_FORMAT_PATTERN.matcher(formatString);
        HashSet<Integer> result = new HashSet<Integer>();
        while (matcher.find()) {
            if (!AbstractPrintfChecker.isMessageFormatPattern(formatString, matcher.start())) continue;
            result.add(Integer.parseInt(matcher.group("index")));
        }
        return result;
    }

    private static boolean isMessageFormatPattern(String formatString, int start) {
        return start == 0 || formatString.charAt(start - 1) != '\'' || StringUtils.countMatches(formatString.substring(0, start), "'") % 2 == 0;
    }

    protected List<String> getParameters(String formatString, MethodInvocationTree mit) {
        ArrayList<String> params = new ArrayList<String>();
        Matcher matcher = PRINTF_PARAM_PATTERN.matcher(formatString);
        while (matcher.find()) {
            if (AbstractPrintfChecker.firstArgumentIsLT(params, matcher.group(2))) {
                this.reportMissingPrevious(mit);
                continue;
            }
            StringBuilder param = new StringBuilder();
            for (int groupIndex : new int[]{1, 2, 5, 6}) {
                if (matcher.group(groupIndex) == null) continue;
                param.append(matcher.group(groupIndex));
            }
            String specifier = param.toString();
            if ("%".equals(specifier)) continue;
            params.add(specifier);
        }
        return params;
    }

    protected void reportMissingPrevious(MethodInvocationTree mit) {
    }

    protected static Integer getIndex(String param) {
        return Integer.valueOf(param.substring(0, param.indexOf(36)));
    }

    protected static void cleanupLineSeparator(List<String> params) {
        Iterator<String> iter = params.iterator();
        while (iter.hasNext()) {
            String param = iter.next();
            if (!"n".equals(param)) continue;
            iter.remove();
        }
    }

    protected static Set<Integer> argIndexes(List<String> params) {
        int index = 0;
        HashSet<Integer> result = new HashSet<Integer>();
        for (String rawParam : params) {
            if (rawParam.contains("$")) {
                result.add(AbstractPrintfChecker.getIndex(rawParam));
                continue;
            }
            if (rawParam.charAt(0) == '<') continue;
            result.add(++index);
        }
        return result;
    }

    private static boolean firstArgumentIsLT(List<String> params, @Nullable String group) {
        return params.isEmpty() && group != null && group.length() > 0 && group.charAt(0) == '<';
    }

    protected boolean checkArgumentNumber(MethodInvocationTree mit, int nbReadParams, int nbArgs) {
        if (nbReadParams > nbArgs) {
            this.reportIssue(mit, "Not enough arguments.");
            return true;
        }
        return false;
    }

    protected void verifyParametersForErrors(MethodInvocationTree mit, List<ExpressionTree> args, List<String> params) {
        int index = 0;
        Iterator<String> iterator = params.iterator();
        while (iterator.hasNext()) {
            String rawParam;
            String param = rawParam = iterator.next();
            int argIndex = index++;
            if (param.contains("$")) {
                argIndex = AbstractPrintfChecker.getIndex(param) - 1;
                if (argIndex == -1) {
                    return;
                }
                param = param.substring(param.indexOf(36) + 1);
            } else if (param.charAt(0) == '<') {
                argIndex = Math.max(0, argIndex - 1);
            }
            if (argIndex >= args.size()) {
                int formatIndex = argIndex + 1;
                this.reportIssue(mit, "Not enough arguments to feed formater at index " + formatIndex + ": '%" + formatIndex + "$'.");
                return;
            }
            ExpressionTree argExpressionTree = args.get(argIndex);
            Type argType = argExpressionTree.symbolType();
            this.checkNumerical(mit, param, argType);
            this.checkTimeConversion(mit, param, argType);
        }
    }

    private void checkNumerical(MethodInvocationTree mit, String param, Type argType) {
        if (param.charAt(0) == 'd' && !AbstractPrintfChecker.isNumerical(argType)) {
            this.reportIssue(mit, "An 'int' is expected rather than a " + argType + ".");
        }
    }

    private void checkTimeConversion(MethodInvocationTree mit, String param, Type argType) {
        if (param.charAt(0) == 't' || param.charAt(0) == 'T') {
            String timeConversion = param.substring(1);
            if (timeConversion.isEmpty()) {
                this.reportIssue(mit, "Time conversion requires a second character.");
                this.checkTimeTypeArgument(mit, argType);
                return;
            }
            if (!TIME_CONVERSIONS.contains(timeConversion)) {
                this.reportIssue(mit, timeConversion + " is not a supported time conversion character");
            }
            this.checkTimeTypeArgument(mit, argType);
        }
    }

    private void checkTimeTypeArgument(MethodInvocationTree mit, Type argType) {
        if (!(argType.isNumerical() || argType.is("java.lang.Long") || AbstractPrintfChecker.isSubtypeOfAny(argType, "java.util.Date", "java.util.Calendar", "java.time.temporal.TemporalAccessor"))) {
            this.reportIssue(mit, "Time argument is expected (long, Long, Calendar, Date and TemporalAccessor).");
        }
    }

    private static boolean isNumerical(Type argType) {
        return argType.isNumerical() || AbstractPrintfChecker.isTypeOfAny(argType, "java.math.BigInteger", "java.math.BigDecimal", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double");
    }

    private static boolean isTypeOfAny(Type argType, String ... fullyQualifiedNames) {
        return Arrays.stream(fullyQualifiedNames).anyMatch(argType::is);
    }

    private static boolean isSubtypeOfAny(Type argType, String ... fullyQualifiedNames) {
        return Arrays.stream(fullyQualifiedNames).anyMatch(argType::isSubtypeOf);
    }
}

