/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.se.NullableAnnotationUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2638")
public class ChangeMethodContractCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        List<Symbol.MethodSymbol> overriddenSymbols = methodSymbol.overriddenSymbols();
        if (overriddenSymbols.isEmpty()) {
            return;
        }
        Symbol.MethodSymbol overridee = overriddenSymbols.get(0);
        if (overridee.isMethodSymbol()) {
            this.checkContractChange(methodTree, overridee);
        }
    }

    private void checkContractChange(MethodTree methodTree, Symbol.MethodSymbol overridee) {
        if (MethodTreeUtils.isEqualsMethod(methodTree)) {
            NullableAnnotationUtils.nonNullAnnotation(methodTree.parameters().get(0).modifiers()).ifPresent(annotation -> this.reportIssue((Tree)annotation, "Equals method should accept null parameters and return false."));
            return;
        }
        for (int i = 0; i < methodTree.parameters().size(); ++i) {
            VariableTree parameter = methodTree.parameters().get(i);
            this.checkParameter(parameter, JUtils.parameterAnnotations(overridee, i));
        }
        if (NullableAnnotationUtils.isAnnotatedNonNull(overridee)) {
            NullableAnnotationUtils.nullableAnnotation(methodTree.modifiers()).ifPresent(annotation -> this.reportIssue((Tree)annotation, "Remove this \"" + annotation.symbolType().name() + "\" annotation to honor the overridden method's contract."));
        }
    }

    private void checkParameter(VariableTree parameter, SymbolMetadata overrideeParamMetadata) {
        if (NullableAnnotationUtils.isAnnotatedNullable(overrideeParamMetadata)) {
            NullableAnnotationUtils.nonNullAnnotation(parameter.modifiers()).ifPresent(annotation -> this.reportIssue((Tree)annotation, "Remove this \"" + annotation.annotationType().symbolType().name() + "\" annotation to honor the overridden method's contract."));
        }
    }
}

