/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S2761")
public class DoublePrefixOperatorCheck
extends IssuableSubscriptionVisitor {
    private Set<ExpressionTree> prefixSet = new HashSet<ExpressionTree>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.LOGICAL_COMPLEMENT, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS);
    }

    @Override
    public void setContext(JavaFileScannerContext context) {
        this.prefixSet.clear();
        super.setContext(context);
    }

    @Override
    public void visitNode(Tree tree) {
        UnaryExpressionTree exprTree = (UnaryExpressionTree)tree;
        if (this.alreadyReported(exprTree)) {
            return;
        }
        ExpressionTree expr = ExpressionUtils.skipParentheses(exprTree.expression());
        if (exprTree.is(expr.kind())) {
            UnaryExpressionTree child = (UnaryExpressionTree)expr;
            if (child.is(Tree.Kind.BITWISE_COMPLEMENT) && !ExpressionUtils.skipParentheses(child.expression()).is(Tree.Kind.BITWISE_COMPLEMENT)) {
                return;
            }
            this.prefixSet.add(child);
            this.reportIssue(exprTree.operatorToken(), child.operatorToken(), "Remove multiple operator prefixes.");
        }
    }

    private boolean alreadyReported(UnaryExpressionTree tree) {
        if (this.prefixSet.contains(tree)) {
            return true;
        }
        Tree parent = tree;
        while (parent.is(Tree.Kind.PARENTHESIZED_EXPRESSION, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.LOGICAL_COMPLEMENT, Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS)) {
            if (!this.prefixSet.contains(parent = parent.parent())) continue;
            return true;
        }
        return false;
    }
}

