/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S2974")
public class FinalClassCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (FinalClassCheck.hasOnlyPrivateConstructors(classTree) && !FinalClassCheck.isExtended(classTree) && !ModifiersUtils.hasModifier(classTree.modifiers(), Modifier.FINAL)) {
            this.reportIssue(classTree.simpleName(), "Make this class \"final\" or add a public constructor.");
        }
    }

    private static boolean isExtended(ClassTree classTree) {
        IsExtendedVisitor isExtendedVisitor = new IsExtendedVisitor(classTree.symbol().type().erasure());
        classTree.accept(isExtendedVisitor);
        return isExtendedVisitor.isExtended;
    }

    private static boolean hasOnlyPrivateConstructors(ClassTree classTree) {
        boolean hasConstructor = false;
        for (Tree member : classTree.members()) {
            if (!member.is(Tree.Kind.CONSTRUCTOR)) continue;
            hasConstructor = true;
            if (ModifiersUtils.hasModifier(((MethodTree)member).modifiers(), Modifier.PRIVATE)) continue;
            return false;
        }
        return hasConstructor;
    }

    private static class IsExtendedVisitor
    extends BaseTreeVisitor {
        private final Type type;
        boolean isExtended;

        IsExtendedVisitor(Type type) {
            this.type = type;
        }

        @Override
        protected void scan(@Nullable Tree tree) {
            if (!this.isExtended) {
                super.scan(tree);
            }
        }

        @Override
        public void visitClass(ClassTree tree) {
            TypeTree superClass = tree.superClass();
            if (superClass != null && superClass.symbolType().erasure() == this.type) {
                this.isExtended = true;
            }
            super.visitClass(tree);
        }

        @Override
        public void visitNewClass(NewClassTree tree) {
            if (tree.classBody() != null && tree.symbolType().isSubtypeOf(this.type)) {
                this.isExtended = true;
            }
            super.visitNewClass(tree);
        }
    }
}

