/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="ObjectFinalizeCheck", repositoryKey="squid")
@Rule(key="S1111")
public class ObjectFinalizeCheck
extends IssuableSubscriptionVisitor {
    private boolean isInFinalizeMethod = false;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.METHOD)) {
            this.isInFinalizeMethod = ObjectFinalizeCheck.isFinalizeMethodMember((MethodTree)tree);
        } else {
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
            IdentifierTree methodName = ExpressionUtils.methodName(methodInvocationTree);
            if (!this.isInFinalizeMethod && "finalize".equals(methodName.name()) && methodInvocationTree.arguments().isEmpty()) {
                this.reportIssue(methodName, "Remove this call to finalize().");
            }
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (tree.is(Tree.Kind.METHOD) && ObjectFinalizeCheck.isFinalizeMethodMember((MethodTree)tree)) {
            this.isInFinalizeMethod = false;
        }
    }

    private static boolean isFinalizeMethodMember(MethodTree methodTree) {
        TypeTree returnType = methodTree.returnType();
        boolean returnVoid = returnType != null && returnType.is(Tree.Kind.PRIMITIVE_TYPE) && "void".equals(((PrimitiveTypeTree)returnType).keyword().text());
        return returnVoid && "finalize".equals(methodTree.simpleName().name());
    }
}

