/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.PackageUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="S00120", repositoryKey="squid")
@Rule(key="S120")
public class BadPackageNameCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String DEFAULT_FORMAT = "^[a-z_]+(\\.[a-z_][a-z0-9_]*)*$";
    @RuleProperty(key="format", description="Regular expression used to check the package names against.", defaultValue="^[a-z_]+(\\.[a-z_][a-z0-9_]*)*$")
    public String format = "^[a-z_]+(\\.[a-z_][a-z0-9_]*)*$";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        String name;
        if (tree.packageDeclaration() != null && !this.pattern.matcher(name = PackageUtils.packageName(tree.packageDeclaration(), ".")).matches()) {
            this.context.reportIssue(this, tree.packageDeclaration().packageName(), "Rename this package name to match the regular expression '" + this.format + "'.");
        }
    }
}

