/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5969")
public class MockingAllMethodsCheck
extends AbstractMethodDetection {
    private final Map<Symbol, Set<Symbol>> mockedMethodsPerObject = new HashMap<Symbol, Set<Symbol>>();
    private final Map<Symbol, MethodInvocationTree> whenCalls = new HashMap<Symbol, MethodInvocationTree>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.METHOD);
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes("org.mockito.Mockito").names("when").withAnyParameters().build();
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.METHOD)) {
            this.mockedMethodsPerObject.clear();
            this.whenCalls.clear();
        } else {
            super.visitNode(tree);
        }
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree argument = (ExpressionTree)mit.arguments().get(0);
        if (argument.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree mockedMethodCall = (MethodInvocationTree)argument;
            ExpressionTree methodSelect = mockedMethodCall.methodSelect();
            if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
                MemberSelectExpressionTree mockedMethod = (MemberSelectExpressionTree)methodSelect;
                ExpressionTree object = mockedMethod.expression();
                if (object.is(Tree.Kind.IDENTIFIER)) {
                    Symbol objectSymbol = ((IdentifierTree)object).symbol();
                    Symbol method = mockedMethod.identifier().symbol();
                    this.mockedMethodsPerObject.computeIfAbsent(objectSymbol, key -> new HashSet()).add(method);
                    this.whenCalls.put(method, mit);
                }
            }
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (tree.is(Tree.Kind.METHOD)) {
            for (Map.Entry<Symbol, Set<Symbol>> entry : this.mockedMethodsPerObject.entrySet()) {
                Symbol mockedObject = entry.getKey();
                Tree declaration = mockedObject.declaration();
                if (declaration == null) continue;
                Set<Symbol> mockedMethods = entry.getValue();
                Set declaredMethods = mockedObject.type().symbol().memberSymbols().stream().filter(MockingAllMethodsCheck::isNonPrivateMethod).collect(Collectors.toSet());
                if (declaredMethods.size() <= 1 || !mockedMethods.containsAll(declaredMethods)) continue;
                List<JavaFileScannerContext.Location> secondaries = mockedMethods.stream().map(method -> new JavaFileScannerContext.Location("Method mocked here", this.whenCalls.get(method))).collect(Collectors.toList());
                this.reportIssue(declaration, "Refactor this test instead of mocking every non-private member of this class.", secondaries, null);
            }
        }
    }

    private static boolean isNonPrivateMethod(Symbol symbol) {
        Tree declaration = symbol.declaration();
        return symbol.isMethodSymbol() && !symbol.isPrivate() && declaration != null && !declaration.is(Tree.Kind.CONSTRUCTOR);
    }
}

