/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.EndOfAnalysisCheck;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.ComplexityVisitor;
import org.sonar.java.model.GeneratedFile;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.Sema;
import org.sonar.java.regex.RegexCache;
import org.sonar.java.regex.RegexCheck;
import org.sonar.java.regex.RegexScannerContext;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.SourceMap;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

public class DefaultJavaFileScannerContext
implements JavaFileScannerContext,
RegexScannerContext {
    private final JavaTree.CompilationUnitTreeImpl tree;
    private final boolean semanticEnabled;
    private final SonarComponents sonarComponents;
    private final ComplexityVisitor complexityVisitor;
    private final RegexCache regexCache;
    private final InputFile inputFile;
    private final JavaVersion javaVersion;
    private final boolean fileParsed;

    public DefaultJavaFileScannerContext(CompilationUnitTree tree, InputFile inputFile, Sema semanticModel, @Nullable SonarComponents sonarComponents, JavaVersion javaVersion, boolean fileParsed) {
        this.tree = (JavaTree.CompilationUnitTreeImpl)tree;
        this.inputFile = inputFile;
        this.semanticEnabled = semanticModel != null;
        this.sonarComponents = sonarComponents;
        this.complexityVisitor = new ComplexityVisitor();
        this.regexCache = new RegexCache();
        this.javaVersion = javaVersion;
        this.fileParsed = fileParsed;
    }

    @Override
    public CompilationUnitTree getTree() {
        return this.tree;
    }

    @Override
    public void addIssueOnFile(JavaCheck javaCheck, String message) {
        this.addIssue(-1, javaCheck, message);
    }

    @Override
    public void addIssueOnProject(JavaCheck check, String message) {
        this.sonarComponents.addIssue(this.getProject(), check, -1, message, 0);
    }

    @Override
    public void addIssue(int line, JavaCheck javaCheck, String message) {
        this.addIssue(line, javaCheck, message, null);
    }

    @Override
    public void addIssue(int line, JavaCheck javaCheck, String message, @Nullable Integer cost) {
        this.sonarComponents.addIssue((InputComponent)this.inputFile, javaCheck, line, message, cost);
    }

    @Override
    @Nullable
    public Object getSemanticModel() {
        if (!this.semanticEnabled) {
            return null;
        }
        return this.tree.sema;
    }

    @Override
    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    public boolean fileParsed() {
        return this.fileParsed;
    }

    @Override
    @Deprecated
    public String getFileKey() {
        return this.inputFile.file().getAbsolutePath();
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree tree, String message) {
        this.reportIssue(javaCheck, tree, message, Collections.emptyList(), null);
    }

    @Override
    public void reportIssue(RegexCheck regexCheck, RegexSyntaxElement regexTree, String message, @Nullable Integer cost, List<RegexCheck.RegexIssueLocation> secondaries) {
        ArrayList<RegexCheck.RegexIssueLocation> completedSecondaries = new ArrayList<RegexCheck.RegexIssueLocation>();
        List<RegexCheck.RegexIssueLocation> mainLocations = new RegexCheck.RegexIssueLocation(regexTree, message).toSingleLocationItems();
        if (mainLocations.size() > 1) {
            mainLocations.subList(1, mainLocations.size()).stream().forEach(completedSecondaries::add);
        }
        completedSecondaries.addAll(secondaries);
        this.reportIssue(regexCheck, mainLocations.get(0).locations().get(0), message, cost, completedSecondaries);
    }

    @Override
    public void reportIssue(RegexCheck regexCheck, Tree javaSyntaxElement, String message, @Nullable Integer cost, List<RegexCheck.RegexIssueLocation> secondaries) {
        this.reportIssue(regexCheck, AnalyzerMessage.textSpanFor(javaSyntaxElement), message, cost, secondaries);
    }

    private void reportIssue(RegexCheck regexCheck, AnalyzerMessage.TextSpan mainLocation, String message, @Nullable Integer cost, List<RegexCheck.RegexIssueLocation> secondaries) {
        ArrayList secondariesAsFlows = new ArrayList();
        secondaries.stream().flatMap(regexIssueLocation -> regexIssueLocation.toSingleLocationItems().stream()).map(Collections::singletonList).forEach(secondariesAsFlows::add);
        AnalyzerMessage analyzerMessage = new AnalyzerMessage((JavaCheck)regexCheck, (InputComponent)this.inputFile, mainLocation, message, cost != null ? cost : 0);
        DefaultJavaFileScannerContext.completeAnalyzerMessageWithFlows(analyzerMessage, secondariesAsFlows, ril -> ril.locations().get(0), RegexCheck.RegexIssueLocation::message);
        this.reportIssue(analyzerMessage);
    }

    @Override
    public RegexParseResult regexForLiterals(FlagSet initialFlags, LiteralTree ... stringLiterals) {
        return this.regexCache.getRegexForLiterals(initialFlags, stringLiterals);
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree syntaxNode, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
        List<List<JavaFileScannerContext.Location>> flows = secondary.stream().map(Collections::singletonList).collect(Collectors.toList());
        this.reportIssueWithFlow(javaCheck, syntaxNode, message, flows, cost);
    }

    @Override
    public void reportIssueWithFlow(JavaCheck javaCheck, Tree syntaxNode, String message, Iterable<List<JavaFileScannerContext.Location>> flows, @Nullable Integer cost) {
        DefaultJavaFileScannerContext.throwIfEndOfAnalysisCheck(javaCheck);
        this.reportIssue(DefaultJavaFileScannerContext.createAnalyzerMessage(this.inputFile, javaCheck, syntaxNode, null, message, flows, cost));
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message) {
        this.reportIssue(javaCheck, startTree, endTree, message, Collections.emptyList(), null);
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
        DefaultJavaFileScannerContext.throwIfEndOfAnalysisCheck(javaCheck);
        List<List<JavaFileScannerContext.Location>> flows = secondary.stream().map(Collections::singletonList).collect(Collectors.toList());
        this.reportIssue(DefaultJavaFileScannerContext.createAnalyzerMessage(this.inputFile, javaCheck, startTree, endTree, message, flows, cost));
    }

    @Override
    public List<String> getFileLines() {
        return this.sonarComponents.fileLines(this.inputFile);
    }

    @Override
    public String getFileContent() {
        return this.sonarComponents.inputFileContents(this.inputFile);
    }

    public void reportIssue(AnalyzerMessage message) {
        this.sonarComponents.reportIssue(message);
    }

    public AnalyzerMessage createAnalyzerMessage(JavaCheck javaCheck, Tree startTree, String message) {
        return DefaultJavaFileScannerContext.createAnalyzerMessage(this.inputFile, javaCheck, startTree, null, message, Collections.emptyList(), null);
    }

    protected static AnalyzerMessage createAnalyzerMessage(InputFile inputFile, JavaCheck javaCheck, Tree startTree, @Nullable Tree endTree, String message, Iterable<List<JavaFileScannerContext.Location>> flows, @Nullable Integer cost) {
        AnalyzerMessage.TextSpan location = endTree != null ? AnalyzerMessage.textSpanBetween(startTree, endTree) : AnalyzerMessage.textSpanFor(startTree);
        AnalyzerMessage analyzerMessage = new AnalyzerMessage(javaCheck, (InputComponent)inputFile, location, message, cost != null ? cost : 0);
        DefaultJavaFileScannerContext.completeAnalyzerMessageWithFlows(analyzerMessage, flows, loc -> AnalyzerMessage.textSpanFor(loc.syntaxNode), loc -> loc.msg);
        return analyzerMessage;
    }

    private static <L> void completeAnalyzerMessageWithFlows(AnalyzerMessage analyzerMessage, Iterable<List<L>> flows, Function<L, AnalyzerMessage.TextSpan> flowItemLocationProdivder, Function<L, String> flowItemMessageProvider) {
        JavaCheck check = analyzerMessage.getCheck();
        InputComponent component = analyzerMessage.getInputComponent();
        for (List<L> flow : flows) {
            List sonarqubeFlow = flow.stream().map(l -> new AnalyzerMessage(check, component, (AnalyzerMessage.TextSpan)flowItemLocationProdivder.apply(l), (String)flowItemMessageProvider.apply(l), 0)).collect(Collectors.toList());
            analyzerMessage.flows.add(sonarqubeFlow);
        }
    }

    @Override
    public InputFile getInputFile() {
        return this.inputFile;
    }

    @Override
    public InputComponent getProject() {
        return this.sonarComponents.project();
    }

    @Override
    public File getWorkingDirectory() {
        return this.sonarComponents.workDir();
    }

    @Override
    public List<Tree> getComplexityNodes(Tree tree) {
        return this.complexityVisitor.getNodes(tree);
    }

    protected static void throwIfEndOfAnalysisCheck(JavaCheck javaCheck) {
        if (javaCheck instanceof EndOfAnalysisCheck) {
            throw new UnsupportedOperationException("EndOfAnalysisCheck must only call reportIssue with AnalyzerMessage and must never pass a Tree reference.");
        }
    }

    @Override
    public Optional<SourceMap> sourceMap() {
        if (this.inputFile instanceof GeneratedFile) {
            return Optional.of(((GeneratedFile)this.inputFile).sourceMap());
        }
        return Optional.empty();
    }
}

