/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionAnnotationLoader;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.BuiltInQualityProfileJsonLoader;
import org.sonarsource.analyzer.commons.JsonParser;
import org.sonarsource.analyzer.commons.Resources;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKeys;

public class RuleMetadataLoader {
    private static final String INVALID_PROPERTY_MESSAGE = "Invalid property: %s";
    private static final char RESOURCE_SEP = '/';
    private static final String SECURITY_HOTSPOT = "SECURITY_HOTSPOT";
    private final String resourceFolder;
    private final Set<String> activatedByDefault;
    private JsonParser jsonParser;

    public RuleMetadataLoader(String resourceFolder) {
        this(resourceFolder, Collections.emptySet());
    }

    public RuleMetadataLoader(String resourceFolder, String defaultProfilePath) {
        this(resourceFolder, BuiltInQualityProfileJsonLoader.loadActiveKeysFromJsonProfile(defaultProfilePath));
    }

    private RuleMetadataLoader(String resourceFolder, Set<String> activatedByDefault) {
        this.resourceFolder = resourceFolder;
        this.jsonParser = new JsonParser();
        this.activatedByDefault = activatedByDefault;
    }

    public void addRulesByAnnotatedClass(RulesDefinition.NewRepository repository, List<Class<?>> ruleClasses) {
        for (Class<?> ruleClass : ruleClasses) {
            this.addRuleByAnnotatedClass(repository, ruleClass);
        }
    }

    public void addRulesByRuleKey(RulesDefinition.NewRepository repository, List<String> ruleKeys) {
        for (String ruleKey : ruleKeys) {
            this.addRuleByRuleKey(repository, ruleKey);
        }
    }

    private RulesDefinition.NewRule addRuleByAnnotatedClass(RulesDefinition.NewRepository repository, Class<?> ruleClass) {
        RulesDefinition.NewRule rule = RuleMetadataLoader.addAnnotatedRule(repository, ruleClass);
        this.setDescriptionFromHtml(rule);
        this.setMetadataFromJson(rule);
        this.setDefaultActivation(rule);
        return rule;
    }

    private void setDefaultActivation(RulesDefinition.NewRule rule) {
        if (this.activatedByDefault.contains(rule.key())) {
            rule.setActivatedByDefault(true);
        }
    }

    private static RulesDefinition.NewRule addAnnotatedRule(RulesDefinition.NewRepository repository, Class<?> ruleClass) {
        Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(ruleClass, Rule.class);
        if (ruleAnnotation == null) {
            throw new IllegalStateException("No Rule annotation was found on " + ruleClass.getName());
        }
        String ruleKey = ruleAnnotation.key();
        if (ruleKey.length() == 0) {
            throw new IllegalStateException("Empty key");
        }
        new RulesDefinitionAnnotationLoader().load((RulesDefinition.NewExtendedRepository)repository, new Class[]{ruleClass});
        RulesDefinition.NewRule rule = repository.rule(ruleKey);
        if (rule == null) {
            throw new IllegalStateException("Rule not found: " + ruleKey);
        }
        DeprecatedRuleKeys deprecatedRuleKeys = (DeprecatedRuleKeys)AnnotationUtils.getAnnotation(ruleClass, DeprecatedRuleKeys.class);
        if (deprecatedRuleKeys != null) {
            Arrays.stream(deprecatedRuleKeys.value()).forEach(deprecatedRuleKey -> RuleMetadataLoader.addDeprecatedRuleKey(repository, rule, deprecatedRuleKey));
        } else {
            DeprecatedRuleKey deprecatedRuleKey2 = (DeprecatedRuleKey)AnnotationUtils.getAnnotation(ruleClass, DeprecatedRuleKey.class);
            if (deprecatedRuleKey2 != null) {
                RuleMetadataLoader.addDeprecatedRuleKey(repository, rule, deprecatedRuleKey2);
            }
        }
        return rule;
    }

    private static void addDeprecatedRuleKey(RulesDefinition.NewRepository repository, RulesDefinition.NewRule rule, DeprecatedRuleKey deprecatedRuleKey) {
        String repoKey = deprecatedRuleKey.repositoryKey().isEmpty() ? repository.key() : deprecatedRuleKey.repositoryKey();
        rule.addDeprecatedRuleKey(repoKey, deprecatedRuleKey.ruleKey());
    }

    private RulesDefinition.NewRule addRuleByRuleKey(RulesDefinition.NewRepository repository, String ruleKey) {
        if (ruleKey.length() == 0) {
            throw new IllegalStateException("Empty key");
        }
        RulesDefinition.NewRule rule = repository.createRule(ruleKey);
        this.setDescriptionFromHtml(rule);
        this.setMetadataFromJson(rule);
        this.setDefaultActivation(rule);
        return rule;
    }

    private void setDescriptionFromHtml(RulesDefinition.NewRule rule) {
        String description;
        String htmlPath = this.resourceFolder + '/' + rule.key() + ".html";
        try {
            description = Resources.toString(htmlPath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read resource: " + htmlPath, e);
        }
        rule.setHtmlDescription(description);
    }

    private void setMetadataFromJson(RulesDefinition.NewRule rule) {
        Object securityStandards;
        Map<String, Object> ruleMetadata = this.getMetadata(rule.key());
        rule.setName(RuleMetadataLoader.getString(ruleMetadata, "title"));
        rule.setSeverity(RuleMetadataLoader.getUpperCaseString(ruleMetadata, "defaultSeverity"));
        String type = RuleMetadataLoader.getUpperCaseString(ruleMetadata, "type");
        rule.setType(RuleType.valueOf((String)type));
        rule.setStatus(RuleStatus.valueOf((String)RuleMetadataLoader.getUpperCaseString(ruleMetadata, "status")));
        rule.setTags(RuleMetadataLoader.getStringArray(ruleMetadata, "tags"));
        Object remediation = ruleMetadata.get("remediation");
        if (remediation != null) {
            RuleMetadataLoader.setRemediationFromJson(rule, (Map)remediation);
        }
        if ((securityStandards = ruleMetadata.get("securityStandards")) != null) {
            RuleMetadataLoader.setSecurityStandardsFromJson(rule, (Map)securityStandards);
        }
    }

    Map<String, Object> getMetadata(String ruleKey) {
        String jsonPath = this.resourceFolder + '/' + ruleKey + ".json";
        try {
            return this.jsonParser.parse(Resources.toString(jsonPath, StandardCharsets.UTF_8));
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Can't read resource: " + jsonPath, e);
        }
    }

    private static void setSecurityStandardsFromJson(RulesDefinition.NewRule rule, Map<String, Object> securityStandards) {
        if (securityStandards.get("OWASP") != null) {
            for (String standard : RuleMetadataLoader.getStringArray(securityStandards, "OWASP")) {
                rule.addOwaspTop10(new RulesDefinition.OwaspTop10[]{RulesDefinition.OwaspTop10.valueOf((String)standard)});
            }
        }
        if (securityStandards.get("CWE") != null) {
            rule.addCwe(RuleMetadataLoader.getIntArray(securityStandards, "CWE"));
        }
    }

    private static void setRemediationFromJson(RulesDefinition.NewRule rule, Map<String, Object> remediation) {
        String func = RuleMetadataLoader.getString(remediation, "func");
        RulesDefinition.DebtRemediationFunctions remediationBuilder = rule.debtRemediationFunctions();
        if (func.startsWith("Constant")) {
            String constantCost = RuleMetadataLoader.getString(remediation, "constantCost");
            rule.setDebtRemediationFunction(remediationBuilder.constantPerIssue(constantCost.replace("mn", "min")));
        } else if ("Linear".equals(func)) {
            String linearFactor = RuleMetadataLoader.getString(remediation, "linearFactor");
            rule.setDebtRemediationFunction(remediationBuilder.linear(linearFactor.replace("mn", "min")));
        } else {
            String linearFactor = RuleMetadataLoader.getString(remediation, "linearFactor");
            String linearOffset = RuleMetadataLoader.getString(remediation, "linearOffset");
            rule.setDebtRemediationFunction(remediationBuilder.linearWithOffset(linearFactor.replace("mn", "min"), linearOffset.replace("mn", "min")));
        }
        if (remediation.get("linearDesc") != null) {
            rule.setGapDescription(RuleMetadataLoader.getString(remediation, "linearDesc"));
        }
    }

    private static String getUpperCaseString(Map<String, Object> map, String propertyName) {
        return RuleMetadataLoader.getString(map, propertyName).toUpperCase(Locale.ROOT);
    }

    private static String getString(Map<String, Object> map, String propertyName) {
        Object propertyValue = map.get(propertyName);
        if (!(propertyValue instanceof String)) {
            throw new IllegalStateException(String.format(INVALID_PROPERTY_MESSAGE, propertyName));
        }
        return (String)propertyValue;
    }

    static String[] getStringArray(Map<String, Object> map, String propertyName) {
        Object propertyValue = map.get(propertyName);
        if (!(propertyValue instanceof List)) {
            throw new IllegalStateException(String.format(INVALID_PROPERTY_MESSAGE, propertyName));
        }
        return ((List)propertyValue).toArray(new String[0]);
    }

    private static int[] getIntArray(Map<String, Object> map, String propertyName) {
        Object propertyValue = map.get(propertyName);
        if (!(propertyValue instanceof List)) {
            throw new IllegalStateException(String.format(INVALID_PROPERTY_MESSAGE, propertyName));
        }
        return ((List)propertyValue).stream().mapToInt(Number::intValue).toArray();
    }

    boolean isSecurityHotspot(Map<String, Object> ruleMetadata) {
        String type = RuleMetadataLoader.getUpperCaseString(ruleMetadata, "type");
        return SECURITY_HOTSPOT.equals(type);
    }
}

