/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.css.plugin.CssRules;
import org.sonar.css.plugin.server.CssAnalyzerBridgeServer;
import org.sonarsource.analyzer.commons.ProgressReport;

public class CssRuleSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(CssRuleSensor.class);
    private static final String CONFIG_PATH = "css-bundle/stylelintconfig.json";
    private final CssRules cssRules;
    private final CssAnalyzerBridgeServer cssAnalyzerBridgeServer;
    private final AnalysisWarnings analysisWarnings;

    public CssRuleSensor(CheckFactory checkFactory, CssAnalyzerBridgeServer cssAnalyzerBridgeServer, @Nullable AnalysisWarnings analysisWarnings) {
        this.cssRules = new CssRules(checkFactory);
        this.cssAnalyzerBridgeServer = cssAnalyzerBridgeServer;
        this.analysisWarnings = analysisWarnings;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.createIssuesForRuleRepository(new String[]{"css"}).name("CSS Rules");
    }

    public void execute(SensorContext context) {
        this.reportOldNodeProperty(context);
        List<InputFile> inputFiles = CssRuleSensor.getInputFiles(context);
        if (inputFiles.isEmpty()) {
            LOG.info("No CSS, PHP, HTML or VueJS files are found in the project. CSS analysis is skipped.");
            return;
        }
        File configFile = null;
        boolean serverRunning = false;
        try {
            serverRunning = this.cssAnalyzerBridgeServer.startServerLazily(context);
            configFile = this.createLinterConfig(context);
        }
        catch (Exception e) {
            String msg = "Failure during CSS analysis preparation, " + this.cssAnalyzerBridgeServer.getCommandInfo();
            CssRuleSensor.logErrorOrWarn(context, msg, e);
            CssRuleSensor.throwFailFast(context, e);
        }
        if (serverRunning && configFile != null) {
            this.analyzeFiles(context, inputFiles, configFile);
        }
    }

    public static void throwFailFast(SensorContext context, Exception e) {
        boolean failFast = context.config().getBoolean("sonar.internal.analysis.failFast").orElse(false);
        if (failFast) {
            throw new IllegalStateException("Analysis failed (\"sonar.internal.analysis.failFast\"=true)", e);
        }
    }

    private void reportOldNodeProperty(SensorContext context) {
        if (context.config().hasKey("sonar.css.node")) {
            String msg = "Property 'sonar.css.node' is ignored, 'sonar.nodejs.executable' should be used instead";
            LOG.warn(msg);
            this.reportAnalysisWarning(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeFiles(SensorContext context, List<InputFile> inputFiles, File configFile) {
        ProgressReport progressReport = new ProgressReport("Analysis progress", TimeUnit.SECONDS.toMillis(10L));
        boolean success = false;
        try {
            progressReport.start(inputFiles.stream().map(InputFile::toString).collect(Collectors.toList()));
            for (InputFile inputFile : inputFiles) {
                this.analyzeFileWithContextCheck(inputFile, context, configFile);
                progressReport.nextFile();
            }
            success = true;
        }
        catch (CancellationException e) {
            LOG.info(e.toString());
        }
        catch (Exception e) {
            String msg = "Failure during CSS analysis, " + this.cssAnalyzerBridgeServer.getCommandInfo();
            CssRuleSensor.logErrorOrWarn(context, msg, e);
            CssRuleSensor.throwFailFast(context, e);
        }
        finally {
            CssRuleSensor.finishProgressReport(progressReport, success);
        }
    }

    private static void finishProgressReport(ProgressReport progressReport, boolean success) {
        if (success) {
            progressReport.stop();
        } else {
            progressReport.cancel();
        }
    }

    void analyzeFileWithContextCheck(InputFile inputFile, SensorContext context, File configFile) {
        if (context.isCancelled()) {
            throw new CancellationException("Analysis interrupted because the SensorContext is in cancelled state");
        }
        if (!this.cssAnalyzerBridgeServer.isAlive()) {
            throw new IllegalStateException("css-bundle server is not answering");
        }
        try {
            this.analyzeFile(context, inputFile, configFile);
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failure during analysis of " + inputFile.uri(), e);
        }
    }

    void analyzeFile(SensorContext context, InputFile inputFile, File configFile) throws IOException {
        URI uri = inputFile.uri();
        if (!"file".equalsIgnoreCase(uri.getScheme())) {
            LOG.debug("Skipping {} as it has not 'file' scheme", (Object)uri);
            return;
        }
        String fileContent = CssRuleSensor.shouldSendFileContent(context, inputFile) ? inputFile.contents() : null;
        CssAnalyzerBridgeServer.Request request = new CssAnalyzerBridgeServer.Request(new File(uri).getAbsolutePath(), fileContent, configFile.toString());
        LOG.debug("Analyzing " + request.filePath);
        CssAnalyzerBridgeServer.Issue[] issues = this.cssAnalyzerBridgeServer.analyze(request);
        LOG.debug("Found {} issue(s)", (Object)issues.length);
        this.saveIssues(context, inputFile, issues);
    }

    private static boolean shouldSendFileContent(SensorContext context, InputFile file) {
        return context.runtime().getProduct() == SonarProduct.SONARLINT || !StandardCharsets.UTF_8.equals(file.charset());
    }

    private void saveIssues(SensorContext context, InputFile inputFile, CssAnalyzerBridgeServer.Issue[] issues) {
        for (CssAnalyzerBridgeServer.Issue issue : issues) {
            NewIssue sonarIssue = context.newIssue();
            RuleKey ruleKey = this.cssRules.getActiveSonarKey(issue.rule);
            if (ruleKey == null) {
                if ("CssSyntaxError".equals(issue.rule)) {
                    String errorMessage = issue.text.replace("(CssSyntaxError)", "").trim();
                    CssRuleSensor.logErrorOrDebug(inputFile, "Failed to parse {}, line {}, {}", inputFile.uri(), issue.line, errorMessage);
                    continue;
                }
                CssRuleSensor.logErrorOrDebug(inputFile, "Unknown stylelint rule or rule not enabled: '" + issue.rule + "'", new Object[0]);
                continue;
            }
            NewIssueLocation location = sonarIssue.newLocation().on((InputComponent)inputFile).at(inputFile.selectLine(issue.line.intValue())).message(CssRuleSensor.normalizeMessage(issue.text));
            sonarIssue.at(location).forRule(ruleKey).save();
        }
    }

    private static void logErrorOrDebug(InputFile file, String msg, Object ... arguments) {
        if ("css".equals(file.language())) {
            LOG.error(msg, arguments);
        } else {
            LOG.debug(msg, arguments);
        }
    }

    private static void logErrorOrWarn(SensorContext context, String msg, Throwable e) {
        if (CssRuleSensor.hasCssFiles(context)) {
            LOG.error(msg, e);
        } else {
            LOG.warn(msg);
        }
    }

    private static List<InputFile> getInputFiles(SensorContext context) {
        FileSystem fileSystem = context.fileSystem();
        FilePredicate mainFilePredicate = fileSystem.predicates().and(fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasLanguages(new String[]{"css", "php", "web"}));
        FilePredicate vueFilePredicate = fileSystem.predicates().and(new FilePredicate[]{fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasExtension("vue"), fileSystem.predicates().hasLanguages(new String[]{"js", "ts"})});
        return StreamSupport.stream(fileSystem.inputFiles(fileSystem.predicates().or(mainFilePredicate, vueFilePredicate)).spliterator(), false).collect(Collectors.toList());
    }

    public static boolean hasCssFiles(SensorContext context) {
        FileSystem fileSystem = context.fileSystem();
        FilePredicate mainFilePredicate = fileSystem.predicates().and(fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasLanguages(new String[]{"css"}));
        return fileSystem.inputFiles(mainFilePredicate).iterator().hasNext();
    }

    private File createLinterConfig(SensorContext context) throws IOException {
        CssRules.StylelintConfig config = this.cssRules.getConfig();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)CssRules.StylelintConfig.class), config);
        Gson gson = gsonBuilder.create();
        String configAsJson = gson.toJson(config);
        File configFile = new File(context.fileSystem().workDir(), CONFIG_PATH).getAbsoluteFile();
        Files.createDirectories(configFile.toPath().getParent(), new FileAttribute[0]);
        Files.write(configFile.toPath(), Collections.singletonList(configAsJson), StandardCharsets.UTF_8, new OpenOption[0]);
        return configFile;
    }

    private static String normalizeMessage(String message) {
        Pattern pattern = Pattern.compile("(.+)\\([a-z\\-]+\\)");
        Matcher matcher = pattern.matcher(message);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return message;
    }

    private void reportAnalysisWarning(String message) {
        if (this.analysisWarnings != null) {
            this.analysisWarnings.addUnique(message);
        }
    }
}

