/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.rule.RuleKey;
import org.sonar.css.plugin.rules.AtRuleNoUnknown;
import org.sonar.css.plugin.rules.BlockNoEmpty;
import org.sonar.css.plugin.rules.ColorNoInvalidHex;
import org.sonar.css.plugin.rules.CommentNoEmpty;
import org.sonar.css.plugin.rules.CssRule;
import org.sonar.css.plugin.rules.DeclarationBlockNoDuplicateProperties;
import org.sonar.css.plugin.rules.DeclarationBlockNoShorthandPropertyOverrides;
import org.sonar.css.plugin.rules.FontFamilyNoDuplicateNames;
import org.sonar.css.plugin.rules.FontFamilyNoMissingGenericFamilyKeyword;
import org.sonar.css.plugin.rules.FunctionCalcNoInvalid;
import org.sonar.css.plugin.rules.FunctionCalcNoUnspacedOperator;
import org.sonar.css.plugin.rules.FunctionLinearGradientNoNonstandardDirection;
import org.sonar.css.plugin.rules.KeyframeDeclarationNoImportant;
import org.sonar.css.plugin.rules.MediaFeatureNameNoUnknown;
import org.sonar.css.plugin.rules.NoDescendingSpecificity;
import org.sonar.css.plugin.rules.NoDuplicateAtImportRules;
import org.sonar.css.plugin.rules.NoDuplicateSelectors;
import org.sonar.css.plugin.rules.NoEmptySource;
import org.sonar.css.plugin.rules.NoExtraSemicolons;
import org.sonar.css.plugin.rules.NoInvalidDoubleSlashComments;
import org.sonar.css.plugin.rules.PropertyNoUnknown;
import org.sonar.css.plugin.rules.SelectorPseudoClassNoUnknown;
import org.sonar.css.plugin.rules.SelectorPseudoElementNoUnknown;
import org.sonar.css.plugin.rules.SelectorTypeNoUnknown;
import org.sonar.css.plugin.rules.StringNoNewline;
import org.sonar.css.plugin.rules.UnitNoUnknown;

public class CssRules {
    private final Map<String, RuleKey> stylelintKeyToRuleKey;
    private final StylelintConfig config = new StylelintConfig();

    public CssRules(CheckFactory checkFactory) {
        Checks checks = checkFactory.create("css").addAnnotatedChecks(CssRules.getRuleClasses());
        Collection enabledRules = checks.all();
        this.stylelintKeyToRuleKey = new HashMap<String, RuleKey>();
        for (CssRule rule : enabledRules) {
            this.stylelintKeyToRuleKey.put(rule.stylelintKey(), checks.ruleKey((Object)rule));
            this.config.rules.put(rule.stylelintKey(), rule.stylelintOptions());
        }
    }

    public static List<Class<?>> getRuleClasses() {
        return Collections.unmodifiableList(Arrays.asList(AtRuleNoUnknown.class, BlockNoEmpty.class, ColorNoInvalidHex.class, CommentNoEmpty.class, DeclarationBlockNoDuplicateProperties.class, DeclarationBlockNoShorthandPropertyOverrides.class, FontFamilyNoDuplicateNames.class, FontFamilyNoMissingGenericFamilyKeyword.class, FunctionCalcNoUnspacedOperator.class, FunctionCalcNoInvalid.class, FunctionLinearGradientNoNonstandardDirection.class, KeyframeDeclarationNoImportant.class, MediaFeatureNameNoUnknown.class, NoDescendingSpecificity.class, NoDuplicateAtImportRules.class, NoDuplicateSelectors.class, NoEmptySource.class, NoExtraSemicolons.class, NoInvalidDoubleSlashComments.class, PropertyNoUnknown.class, SelectorPseudoClassNoUnknown.class, SelectorPseudoElementNoUnknown.class, SelectorTypeNoUnknown.class, StringNoNewline.class, UnitNoUnknown.class));
    }

    @Nullable
    public RuleKey getActiveSonarKey(String stylelintKey) {
        return this.stylelintKeyToRuleKey.get(stylelintKey);
    }

    public StylelintConfig getConfig() {
        return this.config;
    }

    public boolean isEmpty() {
        return this.stylelintKeyToRuleKey.isEmpty();
    }

    public static class StylelintConfig
    implements JsonSerializer<StylelintConfig> {
        Map<String, List<Object>> rules = new HashMap<String, List<Object>>();

        @Override
        public JsonElement serialize(StylelintConfig src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject stylelintJson = new JsonObject();
            JsonObject rulesJson = new JsonObject();
            stylelintJson.add("rules", rulesJson);
            for (Map.Entry<String, List<Object>> stylelintOptions : this.rules.entrySet()) {
                List<Object> config = stylelintOptions.getValue();
                if (config.isEmpty()) {
                    rulesJson.addProperty(stylelintOptions.getKey(), true);
                    continue;
                }
                rulesJson.add(stylelintOptions.getKey(), context.serialize(stylelintOptions.getValue()));
            }
            return stylelintJson;
        }
    }
}

