/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin.server.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Zip {
    private Zip() {
    }

    public static void extract(InputStream bundle, Path destination) throws IOException {
        try (ZipInputStream zip = new ZipInputStream(bundle);){
            ZipEntry entry = zip.getNextEntry();
            if (entry == null) {
                throw new IllegalStateException("At least one entry expected.");
            }
            while (entry != null) {
                Path entryDestination = Zip.entryPath(destination, entry);
                if (entry.isDirectory()) {
                    Files.createDirectories(entryDestination, new FileAttribute[0]);
                } else {
                    Files.copy(zip, entryDestination, StandardCopyOption.REPLACE_EXISTING);
                }
                zip.closeEntry();
                entry = zip.getNextEntry();
            }
        }
    }

    private static Path entryPath(Path targetPath, ZipEntry entry) {
        Path entryPath = targetPath.resolve(entry.getName()).normalize();
        if (!entryPath.startsWith(targetPath)) {
            throw new IllegalStateException("Archive entry " + entry.getName() + " is not within " + targetPath);
        }
        return entryPath;
    }
}

