/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class JavaFilesCache
extends BaseTreeVisitor
implements JavaFileScanner {
    private Set<String> classNames = new HashSet<String>();
    private Deque<String> currentClassKey = new LinkedList<String>();
    private Deque<Tree> parent = new LinkedList<Tree>();
    private Deque<Integer> anonymousInnerClassCounter = new LinkedList<Integer>();
    private String currentPackage;

    public Set<String> getClassNames() {
        return this.classNames;
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        JavaTree.CompilationUnitTreeImpl tree = (JavaTree.CompilationUnitTreeImpl)context.getTree();
        this.currentPackage = JavaTree.PackageDeclarationTreeImpl.packageNameAsString(tree.packageDeclaration()).replace('.', '/');
        this.currentClassKey.clear();
        this.parent.clear();
        this.anonymousInnerClassCounter.clear();
        this.scan(tree);
    }

    @Override
    public void visitClass(ClassTree tree) {
        String className = "";
        IdentifierTree simpleName = tree.simpleName();
        if (simpleName != null) {
            className = simpleName.name();
        }
        String key = this.getClassKey(className);
        this.currentClassKey.push(key);
        this.parent.push(tree);
        this.anonymousInnerClassCounter.push(0);
        this.classNames.add(key);
        super.visitClass(tree);
        this.currentClassKey.pop();
        this.parent.pop();
        this.anonymousInnerClassCounter.pop();
    }

    private String getClassKey(String className) {
        String key = className;
        if (StringUtils.isNotEmpty(this.currentPackage)) {
            key = this.currentPackage + "/" + className;
        }
        if ("".equals(className) || this.parent.peek() != null && this.parent.peek().is(Tree.Kind.METHOD)) {
            int count = this.anonymousInnerClassCounter.pop() + 1;
            key = this.currentClassKey.peek() + "$" + count + className;
            this.anonymousInnerClassCounter.push(count);
        } else if (this.currentClassKey.peek() != null) {
            key = this.currentClassKey.peek() + "$" + className;
        }
        return key;
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.parent.push(tree);
        super.visitMethod(tree);
        this.parent.pop();
    }
}

