/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import java.util.List;
import org.sonar.api.batch.sensor.symbol.NewSymbol;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class SonarSymbolTableVisitor
extends BaseTreeVisitor {
    private final NewSymbolTable newSymbolTable;
    private CompilationUnitTree outerClass;

    public SonarSymbolTableVisitor(NewSymbolTable newSymbolTable) {
        this.newSymbolTable = newSymbolTable;
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        if (this.outerClass == null) {
            this.outerClass = tree;
        }
        super.visitCompilationUnit(tree);
        if (tree.equals(this.outerClass)) {
            this.newSymbolTable.save();
        }
    }

    @Override
    public void visitClass(ClassTree tree) {
        IdentifierTree simpleName = tree.simpleName();
        if (simpleName != null) {
            this.createSymbol(simpleName, tree.symbol().usages());
        }
        for (TypeParameterTree typeParameterTree : tree.typeParameters()) {
            this.createSymbol(typeParameterTree.identifier(), JUtils.typeParameterTreeSymbol(typeParameterTree).usages());
        }
        super.visitClass(tree);
    }

    @Override
    public void visitVariable(VariableTree tree) {
        this.createSymbol(tree.simpleName(), tree.symbol().usages());
        super.visitVariable(tree);
    }

    @Override
    public void visitEnumConstant(EnumConstantTree tree) {
        this.createSymbol(tree.simpleName(), ((VariableTreeImpl)((Object)tree)).symbol().usages());
        super.visitEnumConstant(tree);
    }

    @Override
    public void visitMethod(MethodTree tree) {
        List<IdentifierTree> usages = tree.symbol().usages();
        this.createSymbol(tree.simpleName(), usages);
        for (TypeParameterTree typeParameterTree : tree.typeParameters()) {
            this.createSymbol(typeParameterTree.identifier(), JUtils.typeParameterTreeSymbol(typeParameterTree).usages());
        }
        super.visitMethod(tree);
    }

    @Override
    public void visitLabeledStatement(LabeledStatementTree tree) {
        this.createSymbol(tree.label(), tree.symbol().usages());
        super.visitLabeledStatement(tree);
    }

    @Override
    public void visitImport(ImportTree tree) {
        Symbol symbol;
        IdentifierTree identifierTree = tree.qualifiedIdentifier().is(Tree.Kind.IDENTIFIER) ? (IdentifierTree)tree.qualifiedIdentifier() : ((MemberSelectExpressionTree)tree.qualifiedIdentifier()).identifier();
        if (!"*".equals(identifierTree.name()) && (symbol = JUtils.importTreeSymbol(tree)) != null) {
            this.createSymbol(identifierTree, symbol.usages());
        }
        super.visitImport(tree);
    }

    private void createSymbol(IdentifierTree declaration, List<IdentifierTree> usages) {
        SyntaxToken syntaxToken = declaration.identifierToken();
        NewSymbol newSymbol = this.newSymbolTable.newSymbol(syntaxToken.line(), syntaxToken.column(), syntaxToken.line(), syntaxToken.text().length() + syntaxToken.column());
        for (IdentifierTree usage : usages) {
            syntaxToken = usage.identifierToken();
            newSymbol.newReference(syntaxToken.line(), syntaxToken.column(), syntaxToken.line(), syntaxToken.text().length() + syntaxToken.column());
        }
    }
}

