/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2653")
public class MainInServletCheck
extends IssuableSubscriptionVisitor {
    private static final List<String> SERVLET_AND_EJB_CLASSES = Arrays.asList("javax.servlet.http.HttpServlet", "org.apache.struts.action.Action", "javax.ejb.EnterpriseBean");

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree node = (ClassTree)tree;
        Symbol.TypeSymbol symbol = node.symbol();
        if (MainInServletCheck.isServletOrEjb(symbol)) {
            for (Tree member : node.members()) {
                if (!member.is(Tree.Kind.METHOD) || !MethodTreeUtils.isMainMethod((MethodTree)member)) continue;
                this.reportIssue(((MethodTree)member).simpleName(), "Remove this unwanted \"main\" method.");
            }
        }
    }

    private static boolean isServletOrEjb(Symbol symbol) {
        if (SERVLET_AND_EJB_CLASSES.stream().anyMatch(symbol.type()::isSubtypeOf)) {
            return true;
        }
        return symbol.metadata().annotations().stream().anyMatch(annotation -> annotation.symbol().type().fullyQualifiedName().startsWith("javax.ejb."));
    }
}

