/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S818")
public class UppercaseSuffixesCheck
extends IssuableSubscriptionVisitor {
    @RuleProperty(key="checkOnlyLong", description="Set to \"true\" to ignore \"float\" and \"double\" declarations.", defaultValue="false")
    public boolean checkOnlyLong = false;
    private static final char LONG = 'l';
    private static final char DOUBLE = 'd';
    private static final char FLOAT = 'f';

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.LONG_LITERAL);
    }

    @Override
    public void visitNode(Tree tree) {
        String value = ((LiteralTree)tree).value();
        char suffix = value.charAt(value.length() - 1);
        switch (suffix) {
            case 'd': 
            case 'f': {
                if (this.checkOnlyLong) {
                    return;
                }
            }
            case 'l': {
                this.reportIssue(tree, "Upper-case this literal \"" + suffix + "\" suffix.");
                break;
            }
        }
    }
}

