/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1223")
public class MethodNameSameAsClassCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitClass(ClassTree tree) {
        super.visitClass(tree);
        IdentifierTree classSimpleName = tree.simpleName();
        if (classSimpleName == null) {
            return;
        }
        String className = classSimpleName.name();
        for (Tree member : tree.members()) {
            IdentifierTree simpleName;
            if (!member.is(Tree.Kind.METHOD) || !className.equals((simpleName = ((MethodTree)member).simpleName()).name())) continue;
            this.context.reportIssue(this, simpleName, "Rename this method to prevent any misunderstanding or make it a constructor.");
        }
    }
}

