/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S5326")
public class AndroidSSLConnectionCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Make sure that SSL/TLS connections are validated safely here.";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        List<VariableTree> parameters = methodTree.parameters();
        if (methodTree.simpleName().name().equals("onReceivedSslError") && !parameters.isEmpty() && parameters.get(0).symbol().type().is("android.webkit.WebView")) {
            this.reportIssue(methodTree.simpleName(), MESSAGE);
        }
    }
}

