/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5304")
public class EnvVariablesHotspotCheck
extends AbstractMethodDetection {
    private static final MethodMatchers RUNTIME_EXEC = MethodMatchers.create().ofTypes("java.lang.Runtime").names("exec").withAnyParameters().build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofTypes("java.lang.System").names("getenv").withAnyParameters().build(), MethodMatchers.create().ofTypes("java.lang.ProcessBuilder").names("environment").addWithoutParametersMatcher().build(), RUNTIME_EXEC);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (!EnvVariablesHotspotCheck.isRuntimeExecWithoutSettingEnv(mit)) {
            this.reportIssue(mit, "Make sure that environment variables are used safely here.");
        }
    }

    private static boolean isRuntimeExecWithoutSettingEnv(MethodInvocationTree mit) {
        return RUNTIME_EXEC.matches(mit) && (mit.arguments().size() < 2 || ((ExpressionTree)mit.arguments().get(1)).is(Tree.Kind.NULL_LITERAL));
    }
}

