/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S2391")
public class JunitMethodDeclarationCheck
extends IssuableSubscriptionVisitor {
    private static final String JUNIT_SETUP = "setUp";
    private static final String JUNIT_TEARDOWN = "tearDown";
    private static final String JUNIT_SUITE = "suite";
    private static final int MAX_STRING_DISTANCE = 3;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        if (JunitMethodDeclarationCheck.isJunit3Class((ClassTree)tree)) {
            for (Tree member : ((ClassTree)tree).members()) {
                if (!member.is(Tree.Kind.METHOD)) continue;
                this.visitMethod((MethodTree)member);
            }
        }
    }

    private void visitMethod(MethodTree methodTree) {
        String name = methodTree.simpleName().name();
        TypeTree returnType = methodTree.returnType();
        if (JUNIT_SETUP.equals(name) || JUNIT_TEARDOWN.equals(name)) {
            this.checkSetupTearDownSignature(methodTree);
        } else if (JUNIT_SUITE.equals(name)) {
            this.checkSuiteSignature(methodTree);
        } else if (returnType != null && returnType.symbolType().isSubtypeOf("junit.framework.Test") || this.areVerySimilarStrings(JUNIT_SUITE, name)) {
            this.addIssueForMethodBadName(methodTree, JUNIT_SUITE, name);
        } else if (this.areVerySimilarStrings(JUNIT_SETUP, name)) {
            this.addIssueForMethodBadName(methodTree, JUNIT_SETUP, name);
        } else if (this.areVerySimilarStrings(JUNIT_TEARDOWN, name)) {
            this.addIssueForMethodBadName(methodTree, JUNIT_TEARDOWN, name);
        }
    }

    @VisibleForTesting
    protected boolean areVerySimilarStrings(String expected, String actual) {
        return Math.abs(expected.length() - actual.length()) <= 3 && StringUtils.getLevenshteinDistance(expected, actual) < 3;
    }

    private void checkSuiteSignature(MethodTree methodTree) {
        Symbol.MethodSymbol symbol = methodTree.symbol();
        if (!symbol.isPublic()) {
            this.reportIssue(methodTree, "Make this method \"public\".");
        } else if (!symbol.isStatic()) {
            this.reportIssue(methodTree, "Make this method \"static\".");
        } else if (!methodTree.parameters().isEmpty()) {
            this.reportIssue(methodTree, "This method does not accept parameters.");
        } else {
            TypeTree returnType = methodTree.returnType();
            if (returnType != null && !returnType.symbolType().isSubtypeOf("junit.framework.Test")) {
                this.reportIssue(methodTree, "This method should return either a \"junit.framework.Test\" or a \"junit.framework.TestSuite\".");
            }
        }
    }

    private void checkSetupTearDownSignature(MethodTree methodTree) {
        Symbol.MethodSymbol symbol = methodTree.symbol();
        if (!symbol.isPublic() && !symbol.isProtected()) {
            this.reportIssue(methodTree, "Make this method \"public\".");
        } else if (!methodTree.parameters().isEmpty()) {
            this.reportIssue(methodTree, "This method does not accept parameters.");
        } else {
            TypeTree returnType = methodTree.returnType();
            if (returnType != null && !returnType.symbolType().isVoid()) {
                this.reportIssue(methodTree, "Make this method return \"void\".");
            }
        }
    }

    private void addIssueForMethodBadName(MethodTree methodTree, String expected, String actual) {
        this.reportIssue(methodTree, "This method should be named \"" + expected + "\" not \"" + actual + "\".");
    }

    private void reportIssue(MethodTree methodTree, String message) {
        this.reportIssue(methodTree.simpleName(), message);
    }

    private static boolean isJunit3Class(ClassTree classTree) {
        return classTree.symbol().type().isSubtypeOf("junit.framework.TestCase");
    }
}

