/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.tests.AbstractMockitoArgumentChecker;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6068")
public class MockitoEqSimplificationCheck
extends AbstractMockitoArgumentChecker {
    private static final MethodMatchers MOCKITO_EQ = MethodMatchers.create().ofTypes("org.mockito.ArgumentMatchers", "org.mockito.Matchers", "org.mockito.Mockito").names("eq").withAnyParameters().build();

    @Override
    protected void visitArguments(Arguments arguments) {
        ArrayList<MethodInvocationTree> eqs = new ArrayList<MethodInvocationTree>();
        for (ExpressionTree arg : arguments) {
            if ((arg = ExpressionUtils.skipParentheses(arg)).is(Tree.Kind.METHOD_INVOCATION) && MOCKITO_EQ.matches((MethodInvocationTree)arg)) {
                eqs.add((MethodInvocationTree)arg);
                continue;
            }
            return;
        }
        if (!eqs.isEmpty()) {
            this.reportIssue(((MethodInvocationTree)eqs.get(0)).methodSelect(), String.format("Remove this%s useless \"eq(...)\" invocation; pass the values directly.", eqs.size() == 1 ? "" : " and every subsequent"), eqs.stream().skip(1L).map(eq -> new JavaFileScannerContext.Location("", eq.methodSelect())).collect(Collectors.toList()), null);
        }
    }
}

