/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class ListUtils {
    private ListUtils() {
    }

    public static <T> T getLast(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T getOnlyElement(List<T> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new IllegalArgumentException(String.format("Expected list of size 1, but was list of size %d.", list.size()));
    }

    public static <T> List<T> reverse(List<T> list) {
        ArrayList<T> reversed = new ArrayList<T>(list);
        Collections.reverse(reversed);
        return reversed;
    }

    @SafeVarargs
    public static <T> List<T> concat(List<? extends T> ... lists) {
        return Arrays.stream(lists).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T> List<T> concat(Iterable<? extends T> ... iterables) {
        return Arrays.stream(iterables).flatMap(it -> StreamSupport.stream(it.spliterator(), false)).collect(Collectors.toList());
    }

    public static <T> List<T> alternate(List<? extends T> list1, List<? extends T> list2) {
        int listSize = list1.size();
        int separatorsSize = list2.size();
        ArrayList<T> result = new ArrayList<T>(listSize + separatorsSize);
        Iterator<T> list1Iterator = list1.iterator();
        Iterator<T> list2Iterator = list2.iterator();
        while (list1Iterator.hasNext() || list2Iterator.hasNext()) {
            if (list1Iterator.hasNext()) {
                result.add(list1Iterator.next());
            }
            if (!list2Iterator.hasNext()) continue;
            result.add(list2Iterator.next());
        }
        return result;
    }
}

