/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.matcher.MethodMatcherFactory;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3546")
public class CustomUnclosedResourcesCheck
extends SECheck {
    private final CustomResourceConstraint OPENED = new CustomResourceConstraint("open");
    private final CustomResourceConstraint CLOSED = new CustomResourceConstraint("close");
    @RuleProperty(key="constructor", description="the fully-qualified name of a constructor that creates an open resource. An optional signature may be specified after the class name. E.G. \"org.assoc.res.MyResource\" or \"org.assoc.res.MySpecialResource(java.lang.String, int)\"")
    public String constructor = "";
    @RuleProperty(key="factoryMethod", description="the fully-qualified name of a factory method that returns an open resource, with or without a parameter list. E.G. \"org.assoc.res.ResourceFactory$Innerclass#create\" or \"org.assoc.res.SpecialResourceFactory#create(java.lang.String, int)\"")
    public String factoryMethod = "";
    @RuleProperty(key="openingMethod", description="the fully-qualified name of a method that opens an existing resource, with or without a parameter list. E.G. \"org.assoc.res.ResourceFactory#create\" or \"org.assoc.res.SpecialResourceFactory #create(java.lang.String, int)\"")
    public String openingMethod = "";
    @RuleProperty(key="closingMethod", description="the fully-qualified name of the method which closes the open resource, with or without a parameter list. E.G. \"org.assoc.res.MyResource#closeMe\" or \"org.assoc.res.MySpecialResource#closeMe(java.lang.String, int)\"")
    public String closingMethod = "";
    private MethodMatchers classConstructor;
    private MethodMatchers factoryList;
    private MethodMatchers openingList;
    private MethodMatchers closingList;

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        if (context.getState().exitingOnRuntimeException()) {
            return;
        }
        ExplodedGraph.Node node = context.getNode();
        context.getState().getValuesWithConstraints(this.OPENED).forEach(sv -> this.processUnclosedSymbolicValue(node, (SymbolicValue)sv));
    }

    private void processUnclosedSymbolicValue(ExplodedGraph.Node node, SymbolicValue sv) {
        List<Class<? extends Constraint>> domains = Collections.singletonList(CustomResourceConstraint.class);
        FlowComputation.flowWithoutExceptions(node, sv, this.OPENED::equals, domains, 500000).stream().flatMap(Flow::firstFlowLocation).filter(location -> location.syntaxNode.is(Tree.Kind.NEW_CLASS, Tree.Kind.METHOD_INVOCATION)).forEach(this::reportIssue);
    }

    private void reportIssue(JavaFileScannerContext.Location location) {
        String message = "Close this \"" + CustomUnclosedResourcesCheck.name(location.syntaxNode) + "\".";
        this.reportIssue(location.syntaxNode, message);
    }

    private static String name(Tree tree) {
        if (tree.is(Tree.Kind.NEW_CLASS)) {
            return ((NewClassTree)tree).symbolType().name();
        }
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (mit.symbolType().isVoid()) {
            return mit.symbol().owner().name();
        }
        return mit.symbolType().name();
    }

    private static MethodMatchers createMethodMatchers(String rule) {
        if (rule.length() > 0) {
            return MethodMatcherFactory.methodMatchers(rule);
        }
        return MethodMatchers.none();
    }

    private class PostStatementVisitor
    extends AbstractStatementVisitor {
        protected PostStatementVisitor(CheckerContext context) {
            super(context.getState());
        }

        @Override
        public void visitNewClass(NewClassTree newClassTree) {
            if (this.isCreatingResource(newClassTree)) {
                this.openResource(this.programState.peekValue());
            }
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (this.isCreatingResource(mit)) {
                this.openResource(this.programState.peekValue());
            }
        }

        private boolean isCreatingResource(NewClassTree newClassTree) {
            return this.constructorClasses().matches(newClassTree);
        }

        private MethodMatchers constructorClasses() {
            if (CustomUnclosedResourcesCheck.this.classConstructor == null) {
                CustomUnclosedResourcesCheck.this.classConstructor = MethodMatchers.none();
                if (CustomUnclosedResourcesCheck.this.constructor.length() > 0) {
                    CustomUnclosedResourcesCheck.this.classConstructor = MethodMatcherFactory.constructorMatcher(CustomUnclosedResourcesCheck.this.constructor);
                }
            }
            return CustomUnclosedResourcesCheck.this.classConstructor;
        }

        private boolean isCreatingResource(MethodInvocationTree mit) {
            return this.factoryMethods().matches(mit);
        }

        private MethodMatchers factoryMethods() {
            if (CustomUnclosedResourcesCheck.this.factoryList == null) {
                CustomUnclosedResourcesCheck.this.factoryList = CustomUnclosedResourcesCheck.createMethodMatchers(CustomUnclosedResourcesCheck.this.factoryMethod);
            }
            return CustomUnclosedResourcesCheck.this.factoryList;
        }
    }

    private class PreStatementVisitor
    extends AbstractStatementVisitor {
        protected PreStatementVisitor(CheckerContext context) {
            super(context.getState());
        }

        @Override
        public void visitNewClass(NewClassTree syntaxNode) {
            this.programState.peekValues(syntaxNode.arguments().size()).forEach(this::closeResource);
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (this.isOpeningResource(mit)) {
                this.openResource(this.getTargetSV(mit));
            } else if (this.isClosingResource(mit)) {
                this.closeResource(this.getTargetSV(mit));
            } else {
                this.programState.peekValues(mit.arguments().size()).forEach(this::closeResource);
            }
        }

        private SymbolicValue getTargetSV(MethodInvocationTree mit) {
            return this.programState.peekValue(mit.arguments().size());
        }

        private boolean isOpeningResource(MethodInvocationTree syntaxNode) {
            return this.openingMethods().matches(syntaxNode);
        }

        @Override
        public void visitReturnStatement(ReturnStatementTree syntaxNode) {
            ExpressionTree expression = syntaxNode.expression();
            if (expression != null) {
                this.closeResource(this.programState.peekValue());
            }
        }

        private MethodMatchers openingMethods() {
            if (CustomUnclosedResourcesCheck.this.openingList == null) {
                CustomUnclosedResourcesCheck.this.openingList = CustomUnclosedResourcesCheck.createMethodMatchers(CustomUnclosedResourcesCheck.this.openingMethod);
            }
            return CustomUnclosedResourcesCheck.this.openingList;
        }
    }

    private abstract class AbstractStatementVisitor
    extends CheckerTreeNodeVisitor {
        protected AbstractStatementVisitor(ProgramState programState) {
            super(programState);
        }

        protected void closeResource(@Nullable SymbolicValue target) {
            CustomResourceConstraint oConstraint;
            if (target != null && (oConstraint = this.programState.getConstraint(target, CustomResourceConstraint.class)) != null) {
                this.programState = this.programState.addConstraintTransitively(target.wrappedValue(), CustomUnclosedResourcesCheck.this.CLOSED);
            }
        }

        protected void openResource(SymbolicValue sv) {
            this.programState = this.programState.addConstraintTransitively(sv, CustomUnclosedResourcesCheck.this.OPENED);
        }

        protected boolean isClosingResource(MethodInvocationTree mit) {
            return this.closingMethods().matches(mit);
        }

        private MethodMatchers closingMethods() {
            if (CustomUnclosedResourcesCheck.this.closingList == null) {
                CustomUnclosedResourcesCheck.this.closingList = CustomUnclosedResourcesCheck.createMethodMatchers(CustomUnclosedResourcesCheck.this.closingMethod);
            }
            return CustomUnclosedResourcesCheck.this.closingList;
        }
    }

    public class CustomResourceConstraint
    implements Constraint {
        private final String valueAsString;

        CustomResourceConstraint(String valueAsString) {
            this.valueAsString = valueAsString;
        }

        @Override
        public String valueAsString() {
            return this.valueAsString;
        }
    }
}

