/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.ExtensionProvider;
import org.sonar.api.Plugin;
import org.sonar.api.SonarRuntime;
import org.sonar.api.config.Configuration;
import org.sonar.api.internal.PluginContextImpl;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginRepository;
import org.sonar.scanner.bootstrap.BatchComponents;
import org.sonar.scanner.bootstrap.ExtensionMatcher;

public class ExtensionInstaller {
    private final SonarRuntime sonarRuntime;
    private final PluginRepository pluginRepository;
    private final Configuration bootConfiguration;

    public ExtensionInstaller(SonarRuntime sonarRuntime, PluginRepository pluginRepository, Configuration bootConfiguration) {
        this.sonarRuntime = sonarRuntime;
        this.pluginRepository = pluginRepository;
        this.bootConfiguration = bootConfiguration;
    }

    public ExtensionInstaller install(ComponentContainer container, ExtensionMatcher matcher) {
        for (Object o : BatchComponents.all()) {
            ExtensionInstaller.doInstall(container, matcher, null, o);
        }
        for (PluginInfo pluginInfo : this.pluginRepository.getPluginInfos()) {
            Plugin plugin = this.pluginRepository.getPluginInstance(pluginInfo.getKey());
            Plugin.Context context = new PluginContextImpl.Builder().setSonarRuntime(this.sonarRuntime).setBootConfiguration(this.bootConfiguration).build();
            plugin.define(context);
            for (Object extension : context.getExtensions()) {
                ExtensionInstaller.doInstall(container, matcher, pluginInfo, extension);
            }
        }
        List<ExtensionProvider> providers = container.getComponentsByType(ExtensionProvider.class);
        for (ExtensionProvider provider : providers) {
            Object object = provider.provide();
            if (object instanceof Iterable) {
                for (Object extension : (Iterable)object) {
                    ExtensionInstaller.doInstall(container, matcher, null, extension);
                }
                continue;
            }
            ExtensionInstaller.doInstall(container, matcher, null, object);
        }
        return this;
    }

    private static void doInstall(ComponentContainer container, ExtensionMatcher matcher, @Nullable PluginInfo pluginInfo, Object extension) {
        if (matcher.accept(extension)) {
            container.addExtension(pluginInfo, extension);
        } else {
            container.declareExtension(pluginInfo, extension);
        }
    }
}

