/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchContextIdForNode;
import org.elasticsearch.action.search.SearchScrollAsyncAction;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportResponse;

public final class ClearScrollController
implements Runnable {
    private final DiscoveryNodes nodes;
    private final SearchTransportService searchTransportService;
    private final CountDown expectedOps;
    private final ActionListener<ClearScrollResponse> listener;
    private final AtomicBoolean hasFailed = new AtomicBoolean(false);
    private final AtomicInteger freedSearchContexts = new AtomicInteger(0);
    private final Logger logger;
    private final Runnable runner;

    ClearScrollController(ClearScrollRequest request, ActionListener<ClearScrollResponse> listener, DiscoveryNodes nodes, Logger logger, SearchTransportService searchTransportService) {
        int expectedOps;
        this.nodes = nodes;
        this.logger = logger;
        this.searchTransportService = searchTransportService;
        this.listener = listener;
        List<String> scrollIds = request.getScrollIds();
        if (scrollIds.size() == 1 && "_all".equals(scrollIds.get(0))) {
            expectedOps = nodes.getSize();
            this.runner = this::cleanAllScrolls;
        } else {
            ArrayList contexts = new ArrayList();
            for (String scrollId : request.getScrollIds()) {
                SearchContextIdForNode[] context = TransportSearchHelper.parseScrollId(scrollId).getContext();
                Collections.addAll(contexts, context);
            }
            if (contexts.isEmpty()) {
                expectedOps = 0;
                this.runner = () -> listener.onResponse(new ClearScrollResponse(true, 0));
            } else {
                expectedOps = contexts.size();
                this.runner = () -> this.cleanScrollIds(contexts);
            }
        }
        this.expectedOps = new CountDown(expectedOps);
    }

    @Override
    public void run() {
        this.runner.run();
    }

    void cleanAllScrolls() {
        for (final DiscoveryNode node : this.nodes) {
            try {
                Transport.Connection connection = this.searchTransportService.getConnection(null, node);
                this.searchTransportService.sendClearAllScrollContexts(connection, new ActionListener<TransportResponse>(){

                    @Override
                    public void onResponse(TransportResponse response) {
                        ClearScrollController.this.onFreedContext(true);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        ClearScrollController.this.onFailedFreedContext(e, node);
                    }
                });
            }
            catch (Exception e) {
                this.onFailedFreedContext(e, node);
            }
        }
    }

    void cleanScrollIds(List<SearchContextIdForNode> contextIds) {
        SearchScrollAsyncAction.collectNodesAndRun(contextIds, this.nodes, this.searchTransportService, ActionListener.wrap(lookup -> {
            for (SearchContextIdForNode target : contextIds) {
                DiscoveryNode node = (DiscoveryNode)lookup.apply(target.getClusterAlias(), target.getNode());
                if (node == null) {
                    this.onFreedContext(false);
                    continue;
                }
                try {
                    Transport.Connection connection = this.searchTransportService.getConnection(target.getClusterAlias(), node);
                    this.searchTransportService.sendFreeContext(connection, target.getSearchContextId(), ActionListener.wrap(freed -> this.onFreedContext(freed.isFreed()), e -> this.onFailedFreedContext((Throwable)e, node)));
                }
                catch (Exception e2) {
                    this.onFailedFreedContext(e2, node);
                }
            }
        }, this.listener::onFailure));
    }

    private void onFreedContext(boolean freed) {
        if (freed) {
            this.freedSearchContexts.incrementAndGet();
        }
        if (this.expectedOps.countDown()) {
            boolean succeeded = !this.hasFailed.get();
            this.listener.onResponse(new ClearScrollResponse(succeeded, this.freedSearchContexts.get()));
        }
    }

    private void onFailedFreedContext(Throwable e, DiscoveryNode node) {
        this.logger.warn(() -> new ParameterizedMessage("Clear SC failed on node[{}]", (Object)node), e);
        this.hasFailed.set(true);
        if (this.expectedOps.countDown()) {
            this.listener.onResponse(new ClearScrollResponse(false, this.freedSearchContexts.get()));
        }
    }

    public static void closeContexts(DiscoveryNodes nodes, SearchTransportService searchTransportService, Collection<SearchContextIdForNode> contextIds, ActionListener<Integer> listener) {
        if (contextIds.isEmpty()) {
            listener.onResponse(0);
            return;
        }
        Set<String> clusters = contextIds.stream().filter(ctx -> !Strings.isEmpty(ctx.getClusterAlias())).map(SearchContextIdForNode::getClusterAlias).collect(Collectors.toSet());
        StepListener<BiFunction<String, String, DiscoveryNode>> lookupListener = new StepListener<BiFunction<String, String, DiscoveryNode>>();
        if (!clusters.isEmpty()) {
            searchTransportService.getRemoteClusterService().collectNodes(clusters, lookupListener);
        } else {
            lookupListener.onResponse((cluster, nodeId) -> nodes.get((String)nodeId));
        }
        lookupListener.whenComplete((CheckedConsumer<BiFunction<String, String, DiscoveryNode>, Exception>)((CheckedConsumer)nodeLookup -> {
            GroupedActionListener<Boolean> groupedListener = new GroupedActionListener<Boolean>(listener.map(rs -> Math.toIntExact(rs.stream().filter(r -> r).count())), contextIds.size());
            for (SearchContextIdForNode contextId : contextIds) {
                DiscoveryNode node = (DiscoveryNode)nodeLookup.apply(contextId.getClusterAlias(), contextId.getNode());
                if (node == null) {
                    groupedListener.onResponse(false);
                    continue;
                }
                try {
                    Transport.Connection connection = searchTransportService.getConnection(contextId.getClusterAlias(), node);
                    searchTransportService.sendFreeContext(connection, contextId.getSearchContextId(), ActionListener.wrap(r -> groupedListener.onResponse(r.isFreed()), e -> groupedListener.onResponse(false)));
                }
                catch (Exception e2) {
                    groupedListener.onResponse(false);
                }
            }
        }), listener::onFailure);
    }
}

