/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.OpenPointInTimeRequest;
import org.elasticsearch.action.search.OpenPointInTimeResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportService;

public class TransportOpenPointInTimeAction
extends HandledTransportAction<OpenPointInTimeRequest, OpenPointInTimeResponse> {
    public static final String OPEN_SHARD_READER_CONTEXT_NAME = "indices:data/read/open_reader_context";
    private final TransportSearchAction transportSearchAction;
    private final TransportService transportService;
    private final SearchService searchService;

    @Inject
    public TransportOpenPointInTimeAction(TransportService transportService, SearchService searchService, ActionFilters actionFilters, TransportSearchAction transportSearchAction) {
        super("indices:data/read/open_point_in_time", transportService, actionFilters, OpenPointInTimeRequest::new);
        this.transportService = transportService;
        this.transportSearchAction = transportSearchAction;
        this.searchService = searchService;
        transportService.registerRequestHandler(OPEN_SHARD_READER_CONTEXT_NAME, "same", ShardOpenReaderRequest::new, new ShardOpenReaderRequestHandler());
        TransportActionProxy.registerProxyAction(transportService, OPEN_SHARD_READER_CONTEXT_NAME, false, ShardOpenReaderResponse::new);
    }

    @Override
    protected void doExecute(Task task, OpenPointInTimeRequest request, ActionListener<OpenPointInTimeResponse> listener) {
        SearchRequest searchRequest = new SearchRequest().indices(request.indices()).indicesOptions(request.indicesOptions()).preference(request.preference()).routing(request.routing()).allowPartialSearchResults(false);
        searchRequest.setCcsMinimizeRoundtrips(false);
        this.transportSearchAction.executeRequest(task, searchRequest, "open_search_context", true, (searchTask, shardTarget, connection, phaseListener) -> {
            ShardOpenReaderRequest shardRequest = new ShardOpenReaderRequest(shardTarget.getShardId(), shardTarget.getOriginalIndices(), request.keepAlive());
            this.transportService.sendChildRequest(connection, OPEN_SHARD_READER_CONTEXT_NAME, shardRequest, searchTask, new ActionListenerResponseHandler<SearchPhaseResult>(phaseListener, ShardOpenReaderResponse::new));
        }, listener.map(r -> {
            assert (r.pointInTimeId() != null) : r;
            return new OpenPointInTimeResponse(r.pointInTimeId());
        }));
    }

    private class ShardOpenReaderRequestHandler
    implements TransportRequestHandler<ShardOpenReaderRequest> {
        private ShardOpenReaderRequestHandler() {
        }

        @Override
        public void messageReceived(ShardOpenReaderRequest request, TransportChannel channel, Task task) throws Exception {
            TransportOpenPointInTimeAction.this.searchService.openReaderContext(request.getShardId(), request.keepAlive, new ChannelActionListener(channel, TransportOpenPointInTimeAction.OPEN_SHARD_READER_CONTEXT_NAME, request).map(ShardOpenReaderResponse::new));
        }
    }

    private static final class ShardOpenReaderRequest
    extends TransportRequest
    implements IndicesRequest {
        final ShardId shardId;
        final OriginalIndices originalIndices;
        final TimeValue keepAlive;

        ShardOpenReaderRequest(ShardId shardId, OriginalIndices originalIndices, TimeValue keepAlive) {
            this.shardId = shardId;
            this.originalIndices = originalIndices;
            this.keepAlive = keepAlive;
        }

        ShardOpenReaderRequest(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.originalIndices = OriginalIndices.readOriginalIndices(in);
            this.keepAlive = in.readTimeValue();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
            out.writeTimeValue(this.keepAlive);
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        @Override
        public String[] indices() {
            return this.originalIndices.indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.originalIndices.indicesOptions();
        }
    }

    private static final class ShardOpenReaderResponse
    extends SearchPhaseResult {
        ShardOpenReaderResponse(ShardSearchContextId contextId) {
            this.contextId = contextId;
        }

        ShardOpenReaderResponse(StreamInput in) throws IOException {
            super(in);
            this.contextId = new ShardSearchContextId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.contextId.writeTo(out);
        }
    }
}

