/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.metadata.NodeShutdownComponentStatus;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class SingleNodeShutdownMetadata
extends AbstractDiffable<SingleNodeShutdownMetadata>
implements ToXContentObject,
Diffable<SingleNodeShutdownMetadata> {
    private static final ParseField NODE_ID_FIELD = new ParseField("node_id", new String[0]);
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField REASON_FIELD = new ParseField("reason", new String[0]);
    private static final ParseField STATUS_FIELD = new ParseField("shutdown_status", new String[0]);
    private static final String STARTED_AT_READABLE_FIELD = "shutdown_started";
    private static final ParseField STARTED_AT_MILLIS_FIELD = new ParseField("shutdown_startedmillis", new String[0]);
    private static final ParseField SHARD_MIGRATION_FIELD = new ParseField("shard_migration", new String[0]);
    private static final ParseField PERSISTENT_TASKS_FIELD = new ParseField("persistent_tasks", new String[0]);
    private static final ParseField PLUGINS_STATUS = new ParseField("plugins", new String[0]);
    public static final ConstructingObjectParser<SingleNodeShutdownMetadata, Void> PARSER = new ConstructingObjectParser("node_shutdown_info", a -> new SingleNodeShutdownMetadata((String)a[0], Type.valueOf((String)a[1]), (String)a[2], Status.valueOf((String)a[3]), (Long)a[4], (NodeShutdownComponentStatus)a[5], (NodeShutdownComponentStatus)a[6], (NodeShutdownComponentStatus)a[7]));
    private final String nodeId;
    private final Type type;
    private final String reason;
    private final Status status;
    private final long startedAtMillis;
    private final NodeShutdownComponentStatus shardMigrationStatus;
    private final NodeShutdownComponentStatus persistentTasksStatus;
    private final NodeShutdownComponentStatus pluginsStatus;

    public static SingleNodeShutdownMetadata parse(XContentParser parser) {
        return (SingleNodeShutdownMetadata)PARSER.apply(parser, null);
    }

    private SingleNodeShutdownMetadata(String nodeId, Type type, String reason, Status status, long startedAtMillis, NodeShutdownComponentStatus shardMigrationStatus, NodeShutdownComponentStatus persistentTasksStatus, NodeShutdownComponentStatus pluginsStatus) {
        this.nodeId = Objects.requireNonNull(nodeId, "node ID must not be null");
        this.type = Objects.requireNonNull(type, "shutdown type must not be null");
        this.reason = Objects.requireNonNull(reason, "shutdown reason must not be null");
        this.status = status;
        this.startedAtMillis = startedAtMillis;
        this.shardMigrationStatus = Objects.requireNonNull(shardMigrationStatus, "shard migration status must not be null");
        this.persistentTasksStatus = Objects.requireNonNull(persistentTasksStatus, "persistent tasks status must not be null");
        this.pluginsStatus = Objects.requireNonNull(pluginsStatus, "plugins status must not be null");
    }

    public SingleNodeShutdownMetadata(StreamInput in) throws IOException {
        this.nodeId = in.readString();
        this.type = in.readEnum(Type.class);
        this.reason = in.readString();
        this.status = in.readEnum(Status.class);
        this.startedAtMillis = in.readVLong();
        this.shardMigrationStatus = new NodeShutdownComponentStatus(in);
        this.persistentTasksStatus = new NodeShutdownComponentStatus(in);
        this.pluginsStatus = new NodeShutdownComponentStatus(in);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Type getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public Status getStatus() {
        return this.status;
    }

    public long getStartedAtMillis() {
        return this.startedAtMillis;
    }

    public NodeShutdownComponentStatus getShardMigrationStatus() {
        return this.shardMigrationStatus;
    }

    public NodeShutdownComponentStatus getPersistentTasksStatus() {
        return this.persistentTasksStatus;
    }

    public NodeShutdownComponentStatus getPluginsStatus() {
        return this.pluginsStatus;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        out.writeEnum(this.type);
        out.writeString(this.reason);
        out.writeEnum(this.status);
        out.writeVLong(this.startedAtMillis);
        this.shardMigrationStatus.writeTo(out);
        this.persistentTasksStatus.writeTo(out);
        this.pluginsStatus.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NODE_ID_FIELD.getPreferredName(), this.nodeId);
        builder.field(TYPE_FIELD.getPreferredName(), (Object)this.type);
        builder.field(REASON_FIELD.getPreferredName(), this.reason);
        builder.field(STATUS_FIELD.getPreferredName(), (Object)this.status);
        builder.timeField(STARTED_AT_MILLIS_FIELD.getPreferredName(), STARTED_AT_READABLE_FIELD, this.startedAtMillis);
        builder.field(SHARD_MIGRATION_FIELD.getPreferredName(), (ToXContent)this.shardMigrationStatus);
        builder.field(PERSISTENT_TASKS_FIELD.getPreferredName(), (ToXContent)this.persistentTasksStatus);
        builder.field(PLUGINS_STATUS.getPreferredName(), (ToXContent)this.pluginsStatus);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SingleNodeShutdownMetadata)) {
            return false;
        }
        SingleNodeShutdownMetadata that = (SingleNodeShutdownMetadata)o;
        return this.getStartedAtMillis() == that.getStartedAtMillis() && this.getNodeId().equals(that.getNodeId()) && this.getType() == that.getType() && this.getReason().equals(that.getReason()) && this.status == that.status && this.shardMigrationStatus.equals(that.shardMigrationStatus) && this.persistentTasksStatus.equals(that.persistentTasksStatus) && this.pluginsStatus.equals(that.pluginsStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getNodeId(), this.getType(), this.getReason(), this.status, this.getStartedAtMillis(), this.shardMigrationStatus, this.persistentTasksStatus, this.pluginsStatus});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SingleNodeShutdownMetadata original) {
        if (original == null) {
            return SingleNodeShutdownMetadata.builder();
        }
        return new Builder().setNodeId(original.getNodeId()).setType(original.getType()).setReason(original.getReason()).setStatus(original.getStatus()).setStartedAtMillis(original.getStartedAtMillis()).setShardMigrationStatus(original.getShardMigrationStatus()).setPersistentTasksStatus(original.getPersistentTasksStatus()).setPluginsStatus(original.getPluginsStatus());
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NODE_ID_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), REASON_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), STATUS_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), STARTED_AT_MILLIS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, context) -> NodeShutdownComponentStatus.parse(parser), SHARD_MIGRATION_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, context) -> NodeShutdownComponentStatus.parse(parser), PERSISTENT_TASKS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, context) -> NodeShutdownComponentStatus.parse(parser), PLUGINS_STATUS);
    }

    public static enum Type {
        REMOVE,
        RESTART;

    }

    public static enum Status {
        NOT_STARTED,
        IN_PROGRESS,
        STALLED,
        COMPLETE;

    }

    public static class Builder {
        private String nodeId;
        private Type type;
        private String reason;
        private long startedAtMillis = -1L;
        private Status status = Status.IN_PROGRESS;
        private NodeShutdownComponentStatus shardMigrationStatus = new NodeShutdownComponentStatus();
        private NodeShutdownComponentStatus persistentTasksStatus = new NodeShutdownComponentStatus();
        private NodeShutdownComponentStatus pluginsStatus = new NodeShutdownComponentStatus();

        private Builder() {
        }

        public Builder setNodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setReason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder setStartedAtMillis(long startedAtMillis) {
            this.startedAtMillis = startedAtMillis;
            return this;
        }

        public Builder setStatus(Status status) {
            this.status = status;
            return this;
        }

        public Builder setShardMigrationStatus(NodeShutdownComponentStatus shardMigrationStatus) {
            this.shardMigrationStatus = shardMigrationStatus;
            return this;
        }

        public Builder setPersistentTasksStatus(NodeShutdownComponentStatus persistentTasksStatus) {
            this.persistentTasksStatus = persistentTasksStatus;
            return this;
        }

        public Builder setPluginsStatus(NodeShutdownComponentStatus pluginsStatus) {
            this.pluginsStatus = pluginsStatus;
            return this;
        }

        public SingleNodeShutdownMetadata build() {
            if (this.startedAtMillis == -1L) {
                throw new IllegalArgumentException("start timestamp must be set");
            }
            return new SingleNodeShutdownMetadata(this.nodeId, this.type, this.reason, this.status, this.startedAtMillis, this.shardMigrationStatus, this.persistentTasksStatus, this.pluginsStatus);
        }
    }
}

