/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LazySoftDeletesDirectoryReaderWrapper;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SoftDeletesDirectoryReaderWrapper;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.elasticsearch.Version;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.engine.CompletionStatsCache;
import org.elasticsearch.index.engine.ElasticsearchReaderManager;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.RamAccountingRefreshListener;
import org.elasticsearch.index.engine.SafeCommitInfo;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.ShardLongFieldRange;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogDeletionPolicy;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.transport.Transports;

public class ReadOnlyEngine
extends Engine {
    public static final String FIELD_RANGE_SEARCH_SOURCE = "field_range";
    private final SegmentInfos lastCommittedSegmentInfos;
    private final SeqNoStats seqNoStats;
    private final ElasticsearchReaderManager readerManager;
    private final IndexCommit indexCommit;
    private final Lock indexWriterLock;
    private final RamAccountingRefreshListener refreshListener;
    private final SafeCommitInfo safeCommitInfo;
    private final CompletionStatsCache completionStatsCache;
    private final boolean requireCompleteHistory;
    final boolean lazilyLoadSoftDeletes;
    protected volatile TranslogStats translogStats;
    private final String commitId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReadOnlyEngine(EngineConfig config, SeqNoStats seqNoStats, TranslogStats translogStats, boolean obtainLock, Function<DirectoryReader, DirectoryReader> readerWrapperFunction, boolean requireCompleteHistory, boolean lazilyLoadSoftDeletes) {
        super(config);
        this.refreshListener = new RamAccountingRefreshListener(this.engineConfig.getCircuitBreakerService());
        this.requireCompleteHistory = requireCompleteHistory;
        try {
            Store store = config.getStore();
            store.incRef();
            ElasticsearchDirectoryReader reader = null;
            Directory directory = store.directory();
            Lock indexWriterLock = null;
            boolean success = false;
            try {
                indexWriterLock = obtainLock ? directory.obtainLock("write.lock") : null;
                this.lastCommittedSegmentInfos = Lucene.readSegmentInfos(directory);
                this.commitId = ReadOnlyEngine.generateSearcherId(this.lastCommittedSegmentInfos);
                if (seqNoStats == null) {
                    seqNoStats = ReadOnlyEngine.buildSeqNoStats(config, this.lastCommittedSegmentInfos);
                    this.ensureMaxSeqNoEqualsToGlobalCheckpoint(seqNoStats);
                }
                this.seqNoStats = seqNoStats;
                this.indexCommit = Lucene.getIndexCommit(this.lastCommittedSegmentInfos, directory);
                this.lazilyLoadSoftDeletes = lazilyLoadSoftDeletes;
                reader = this.wrapReader(this.open(this.indexCommit), readerWrapperFunction);
                this.readerManager = new ElasticsearchReaderManager(reader, this.refreshListener);
                assert (translogStats != null || obtainLock) : "mutiple translogs instances should not be opened at the same time";
                this.translogStats = translogStats != null ? translogStats : ReadOnlyEngine.translogStats(config, this.lastCommittedSegmentInfos);
                this.indexWriterLock = indexWriterLock;
                this.safeCommitInfo = new SafeCommitInfo(seqNoStats.getLocalCheckpoint(), this.lastCommittedSegmentInfos.totalMaxDoc());
                this.completionStatsCache = new CompletionStatsCache(() -> this.acquireSearcher("completion_stats"));
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                Closeable[] closeableArray = new Closeable[3];
                closeableArray[0] = reader;
                closeableArray[1] = indexWriterLock;
                closeableArray[2] = store::decRef;
                IOUtils.close((Closeable[])closeableArray);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static String generateSearcherId(SegmentInfos sis) {
        MessageDigest md = MessageDigests.sha256();
        for (SegmentCommitInfo si : sis) {
            byte[] segmentId = si.getId();
            if (segmentId != null) {
                md.update(segmentId);
                continue;
            }
            return null;
        }
        return MessageDigests.toHexString(md.digest());
    }

    protected void ensureMaxSeqNoEqualsToGlobalCheckpoint(SeqNoStats seqNoStats) {
        if (!this.requireCompleteHistory) {
            return;
        }
        Version indexVersionCreated = this.engineConfig.getIndexSettings().getIndexVersionCreated();
        if (indexVersionCreated.onOrAfter(Version.V_7_2_0) || seqNoStats.getGlobalCheckpoint() != -2L && indexVersionCreated.onOrAfter(Version.V_6_7_0)) {
            assert (this.assertMaxSeqNoEqualsToGlobalCheckpoint(seqNoStats.getMaxSeqNo(), seqNoStats.getGlobalCheckpoint()));
            if (seqNoStats.getMaxSeqNo() != seqNoStats.getGlobalCheckpoint()) {
                throw new IllegalStateException("Maximum sequence number [" + seqNoStats.getMaxSeqNo() + "] from last commit does not match global checkpoint [" + seqNoStats.getGlobalCheckpoint() + "]");
            }
        }
    }

    protected boolean assertMaxSeqNoEqualsToGlobalCheckpoint(long maxSeqNo, long globalCheckpoint) {
        assert (maxSeqNo == globalCheckpoint) : "max seq. no. [" + maxSeqNo + "] does not match [" + globalCheckpoint + "]";
        return true;
    }

    @Override
    public void verifyEngineBeforeIndexClosing() throws IllegalStateException {
    }

    protected final ElasticsearchDirectoryReader wrapReader(DirectoryReader reader, Function<DirectoryReader, DirectoryReader> readerWrapperFunction) throws IOException {
        reader = readerWrapperFunction.apply(reader);
        return ElasticsearchDirectoryReader.wrap(reader, this.engineConfig.getShardId());
    }

    protected DirectoryReader open(IndexCommit commit) throws IOException {
        assert (Transports.assertNotTransportThread("opening index commit of a read-only engine"));
        if (this.engineConfig.getIndexSettings().isSoftDeleteEnabled()) {
            if (this.lazilyLoadSoftDeletes) {
                return new LazySoftDeletesDirectoryReaderWrapper(DirectoryReader.open((IndexCommit)commit), "__soft_deletes");
            }
            return new SoftDeletesDirectoryReaderWrapper(DirectoryReader.open((IndexCommit)commit), "__soft_deletes");
        }
        return DirectoryReader.open((IndexCommit)commit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNoLock(String reason, CountDownLatch closedLatch) {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                Closeable[] closeableArray = new Closeable[3];
                closeableArray[0] = this.readerManager;
                closeableArray[1] = this.indexWriterLock;
                closeableArray[2] = this.store::decRef;
                IOUtils.close((Closeable[])closeableArray);
            }
            catch (Exception ex) {
                this.logger.warn("failed to close reader", (Throwable)ex);
            }
            finally {
                closedLatch.countDown();
            }
        }
    }

    private static SeqNoStats buildSeqNoStats(EngineConfig config, SegmentInfos infos) {
        SequenceNumbers.CommitInfo seqNoStats = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(infos.userData.entrySet());
        long maxSeqNo = seqNoStats.maxSeqNo;
        long localCheckpoint = seqNoStats.localCheckpoint;
        return new SeqNoStats(maxSeqNo, localCheckpoint, config.getGlobalCheckpointSupplier().getAsLong());
    }

    private static TranslogStats translogStats(EngineConfig config, SegmentInfos infos) throws IOException {
        String translogUuid = (String)infos.getUserData().get("translog_uuid");
        if (translogUuid == null) {
            throw new IllegalStateException("commit doesn't contain translog unique id");
        }
        TranslogConfig translogConfig = config.getTranslogConfig();
        TranslogDeletionPolicy translogDeletionPolicy = new TranslogDeletionPolicy(config.getIndexSettings().getTranslogRetentionSize().getBytes(), config.getIndexSettings().getTranslogRetentionAge().getMillis(), config.getIndexSettings().getTranslogRetentionTotalFiles());
        long localCheckpoint = Long.parseLong((String)infos.getUserData().get("local_checkpoint"));
        translogDeletionPolicy.setLocalCheckpointOfSafeCommit(localCheckpoint);
        try (Translog translog = new Translog(translogConfig, translogUuid, translogDeletionPolicy, config.getGlobalCheckpointSupplier(), config.getPrimaryTermSupplier(), seqNo -> {});){
            TranslogStats translogStats = translog.stats();
            return translogStats;
        }
    }

    @Override
    public Engine.GetResult get(Engine.Get get, DocumentMapper mapper, Function<Engine.Searcher, Engine.Searcher> searcherWrapper) {
        return this.getFromSearcher(get, this.acquireSearcher("get", Engine.SearcherScope.EXTERNAL, searcherWrapper));
    }

    @Override
    protected ReferenceManager<ElasticsearchDirectoryReader> getReferenceManager(Engine.SearcherScope scope) {
        return this.readerManager;
    }

    @Override
    protected SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    @Override
    public String getHistoryUUID() {
        return (String)this.lastCommittedSegmentInfos.userData.get("history_uuid");
    }

    @Override
    public long getWritingBytes() {
        return 0L;
    }

    @Override
    public long getIndexThrottleTimeInMillis() {
        return 0L;
    }

    @Override
    public boolean isThrottled() {
        return false;
    }

    @Override
    public Engine.IndexResult index(Engine.Index index) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("indexing is not supported on a read-only engine");
    }

    @Override
    public Engine.DeleteResult delete(Engine.Delete delete) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("deletes are not supported on a read-only engine");
    }

    @Override
    public Engine.NoOpResult noOp(Engine.NoOp noOp) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("no-ops are not supported on a read-only engine");
    }

    @Override
    public boolean isTranslogSyncNeeded() {
        return false;
    }

    @Override
    public boolean ensureTranslogSynced(Stream<Translog.Location> locations) {
        return false;
    }

    @Override
    public void syncTranslog() {
    }

    @Override
    public Closeable acquireHistoryRetentionLock(Engine.HistorySource historySource) {
        return () -> {};
    }

    @Override
    public Translog.Snapshot newChangesSnapshot(String source, MapperService mapperService, long fromSeqNo, long toSeqNo, boolean requiredFullRange) throws IOException {
        if (!this.engineConfig.getIndexSettings().isSoftDeleteEnabled()) {
            throw new IllegalStateException("accessing changes snapshot requires soft-deletes enabled");
        }
        return this.newEmptySnapshot();
    }

    @Override
    public Translog.Snapshot readHistoryOperations(String reason, Engine.HistorySource historySource, MapperService mapperService, long startingSeqNo) {
        return this.newEmptySnapshot();
    }

    @Override
    public int estimateNumberOfHistoryOperations(String reason, Engine.HistorySource historySource, MapperService mapperService, long startingSeqNo) {
        return 0;
    }

    @Override
    public boolean hasCompleteOperationHistory(String reason, Engine.HistorySource historySource, MapperService mapperService, long startingSeqNo) {
        return startingSeqNo > this.seqNoStats.getMaxSeqNo();
    }

    @Override
    public long getMinRetainedSeqNo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TranslogStats getTranslogStats() {
        return this.translogStats;
    }

    @Override
    public Translog.Location getTranslogLastWriteLocation() {
        return new Translog.Location(0L, 0L, 0);
    }

    @Override
    public long getPersistedLocalCheckpoint() {
        return this.seqNoStats.getLocalCheckpoint();
    }

    @Override
    public SeqNoStats getSeqNoStats(long globalCheckpoint) {
        return new SeqNoStats(this.seqNoStats.getMaxSeqNo(), this.seqNoStats.getLocalCheckpoint(), globalCheckpoint);
    }

    @Override
    public long getLastSyncedGlobalCheckpoint() {
        return this.seqNoStats.getGlobalCheckpoint();
    }

    @Override
    public long getIndexBufferRAMBytesUsed() {
        return 0L;
    }

    @Override
    public List<Segment> segments(boolean verbose) {
        return Arrays.asList(this.getSegmentInfo(this.lastCommittedSegmentInfos, verbose));
    }

    @Override
    public void refresh(String source) {
    }

    @Override
    public boolean maybeRefresh(String source) throws EngineException {
        return false;
    }

    @Override
    public void writeIndexingBuffer() throws EngineException {
    }

    @Override
    public boolean shouldPeriodicallyFlush() {
        return false;
    }

    @Override
    public Engine.SyncedFlushResult syncFlush(String syncId, Engine.CommitId expectedCommitId) {
        throw new UnsupportedOperationException("syncedFlush is not supported on a read-only engine");
    }

    @Override
    public Engine.CommitId flush(boolean force, boolean waitIfOngoing) throws EngineException {
        return new Engine.CommitId(this.lastCommittedSegmentInfos.getId());
    }

    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade, boolean upgradeOnlyAncientSegments, String forceMergeUUID) {
        if (maxNumSegments != -1) {
            if (maxNumSegments < this.lastCommittedSegmentInfos.size()) {
                throw new UnsupportedOperationException("force merge is not supported on a read-only engine, target max number of segments[" + maxNumSegments + "], current number of segments[" + this.lastCommittedSegmentInfos.size() + "].");
            }
            this.logger.debug("current number of segments[{}] is not greater than target max number of segments[{}].", (Object)this.lastCommittedSegmentInfos.size(), (Object)maxNumSegments);
        }
    }

    @Override
    public Engine.IndexCommitRef acquireLastIndexCommit(boolean flushFirst) {
        this.store.incRef();
        return new Engine.IndexCommitRef(this.indexCommit, (CheckedRunnable<IOException>)((CheckedRunnable)this.store::decRef));
    }

    @Override
    public Engine.IndexCommitRef acquireSafeIndexCommit() {
        return this.acquireLastIndexCommit(false);
    }

    @Override
    public SafeCommitInfo getSafeCommitInfo() {
        return this.safeCommitInfo;
    }

    @Override
    public void activateThrottling() {
    }

    @Override
    public void deactivateThrottling() {
    }

    @Override
    public void trimUnreferencedTranslogFiles() {
    }

    @Override
    public boolean shouldRollTranslogGeneration() {
        return false;
    }

    @Override
    public void rollTranslogGeneration() {
    }

    @Override
    public int restoreLocalHistoryFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner) {
        return 0;
    }

    @Override
    public int fillSeqNoGaps(long primaryTerm) {
        return 0;
    }

    @Override
    public Engine recoverFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner, long recoverUpToSeqNo) {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            try (Translog.Snapshot snapshot = this.newEmptySnapshot();){
                translogRecoveryRunner.run(this, snapshot);
            }
            catch (Exception e) {
                throw new EngineException(this.shardId, "failed to recover from empty translog snapshot", e, new Object[0]);
            }
        }
        return this;
    }

    @Override
    public void skipTranslogRecovery() {
    }

    @Override
    public void trimOperationsFromTranslog(long belowTerm, long aboveSeqNo) {
    }

    @Override
    public void maybePruneDeletes() {
    }

    @Override
    public void updateMaxUnsafeAutoIdTimestamp(long newTimestamp) {
    }

    protected void processReader(ElasticsearchDirectoryReader reader) {
        this.refreshListener.accept(reader, null);
    }

    @Override
    public boolean refreshNeeded() {
        return false;
    }

    private Translog.Snapshot newEmptySnapshot() {
        return new Translog.Snapshot(){

            @Override
            public void close() {
            }

            @Override
            public int totalOperations() {
                return 0;
            }

            @Override
            public Translog.Operation next() {
                return null;
            }
        };
    }

    @Override
    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.seqNoStats.getMaxSeqNo();
    }

    @Override
    public void advanceMaxSeqNoOfUpdatesOrDeletes(long maxSeqNoOfUpdatesOnPrimary) {
        assert (maxSeqNoOfUpdatesOnPrimary <= this.getMaxSeqNoOfUpdatesOrDeletes()) : maxSeqNoOfUpdatesOnPrimary + ">" + this.getMaxSeqNoOfUpdatesOrDeletes();
    }

    protected DirectoryReader openDirectory(Directory directory, boolean wrapSoftDeletes) throws IOException {
        assert (Transports.assertNotTransportThread("opening directory reader of a read-only engine"));
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        if (wrapSoftDeletes) {
            if (this.lazilyLoadSoftDeletes) {
                return new LazySoftDeletesDirectoryReaderWrapper(reader, "__soft_deletes");
            }
            return new SoftDeletesDirectoryReaderWrapper(reader, "__soft_deletes");
        }
        return reader;
    }

    @Override
    public CompletionStats completionStats(String ... fieldNamePatterns) {
        return this.completionStatsCache.get(fieldNamePatterns);
    }

    @Override
    public ShardLongFieldRange getRawFieldRange(String field) throws IOException {
        try (Engine.Searcher searcher = this.acquireSearcher(FIELD_RANGE_SEARCH_SOURCE);){
            DirectoryReader directoryReader = searcher.getDirectoryReader();
            byte[] minPackedValue = PointValues.getMinPackedValue((IndexReader)directoryReader, (String)field);
            byte[] maxPackedValue = PointValues.getMaxPackedValue((IndexReader)directoryReader, (String)field);
            if (minPackedValue == null || maxPackedValue == null) {
                assert (minPackedValue == null && maxPackedValue == null) : Arrays.toString(minPackedValue) + "-" + Arrays.toString(maxPackedValue);
                ShardLongFieldRange shardLongFieldRange = ShardLongFieldRange.EMPTY;
                return shardLongFieldRange;
            }
            ShardLongFieldRange shardLongFieldRange = ShardLongFieldRange.of(LongPoint.decodeDimension((byte[])minPackedValue, (int)0), LongPoint.decodeDimension((byte[])maxPackedValue, (int)0));
            return shardLongFieldRange;
        }
    }

    @Override
    public Engine.SearcherSupplier acquireSearcherSupplier(Function<Engine.Searcher, Engine.Searcher> wrapper, Engine.SearcherScope scope) throws EngineException {
        final Engine.SearcherSupplier delegate = super.acquireSearcherSupplier(wrapper, scope);
        return new Engine.SearcherSupplier(Function.identity()){

            @Override
            protected void doClose() {
                delegate.close();
            }

            @Override
            protected Engine.Searcher acquireSearcherInternal(String source) {
                return delegate.acquireSearcherInternal(source);
            }

            @Override
            public String getSearcherId() {
                return ReadOnlyEngine.this.commitId;
            }
        };
    }

    public final String getCommitId() {
        return this.commitId;
    }
}

