/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;

final class SingleDocDirectoryReader
extends DirectoryReader {
    private final SingleDocLeafReader leafReader;

    SingleDocDirectoryReader(ShardId shardId, Translog.Index operation, DocumentMapper mapper, Analyzer analyzer) throws IOException {
        this(new SingleDocLeafReader(shardId, operation, mapper, analyzer));
    }

    private SingleDocDirectoryReader(SingleDocLeafReader leafReader) throws IOException {
        super(leafReader.directory, new LeafReader[]{leafReader});
        this.leafReader = leafReader;
    }

    boolean assertMemorySegmentStatus(boolean loaded) {
        return this.leafReader.assertMemorySegmentStatus(loaded);
    }

    private static UnsupportedOperationException unsupported() {
        assert (false) : "unsupported operation";
        return new UnsupportedOperationException();
    }

    protected DirectoryReader doOpenIfChanged() {
        throw SingleDocDirectoryReader.unsupported();
    }

    protected DirectoryReader doOpenIfChanged(IndexCommit commit) {
        throw SingleDocDirectoryReader.unsupported();
    }

    protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) {
        throw SingleDocDirectoryReader.unsupported();
    }

    public long getVersion() {
        throw SingleDocDirectoryReader.unsupported();
    }

    public boolean isCurrent() {
        throw SingleDocDirectoryReader.unsupported();
    }

    public IndexCommit getIndexCommit() {
        throw SingleDocDirectoryReader.unsupported();
    }

    protected void doClose() throws IOException {
        this.leafReader.close();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.leafReader.getReaderCacheHelper();
    }

    private static class SingleDocLeafReader
    extends LeafReader {
        private final ShardId shardId;
        private final Translog.Index operation;
        private final DocumentMapper mapper;
        private final Analyzer analyzer;
        private final Directory directory;
        private final AtomicReference<LeafReader> delegate = new AtomicReference();

        SingleDocLeafReader(ShardId shardId, Translog.Index operation, DocumentMapper mapper, Analyzer analyzer) {
            this.shardId = shardId;
            this.operation = operation;
            this.mapper = mapper;
            this.analyzer = analyzer;
            this.directory = new ByteBuffersDirectory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LeafReader getDelegate() {
            this.ensureOpen();
            LeafReader reader = this.delegate.get();
            if (reader == null) {
                SingleDocLeafReader singleDocLeafReader = this;
                synchronized (singleDocLeafReader) {
                    reader = this.delegate.get();
                    if (reader == null) {
                        reader = this.createInMemoryLeafReader();
                        LeafReader existing = this.delegate.getAndSet(reader);
                        assert (existing == null);
                    }
                }
            }
            return reader;
        }

        private LeafReader createInMemoryLeafReader() {
            LeafReader leafReader;
            assert (Thread.holdsLock((Object)this));
            ParsedDocument parsedDocs = this.mapper.parse(new SourceToParse(this.shardId.getIndexName(), this.operation.type(), this.operation.id(), this.operation.source(), XContentHelper.xContentType(this.operation.source()), this.operation.routing(), Collections.emptyMap()));
            parsedDocs.updateSeqID(this.operation.seqNo(), this.operation.primaryTerm());
            parsedDocs.version().setLongValue(this.operation.version());
            IndexWriterConfig writeConfig = new IndexWriterConfig(this.analyzer).setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            IndexWriter writer = new IndexWriter(this.directory, writeConfig);
            try {
                writer.addDocument((Iterable)parsedDocs.rootDoc());
                DirectoryReader reader = DirectoryReader.open((IndexWriter)writer);
                if (reader.leaves().size() != 1 || ((LeafReaderContext)reader.leaves().get(0)).reader().numDocs() != 1) {
                    reader.close();
                    throw new IllegalStateException("Expected a single document segment; but [" + reader.leaves().size() + " segments with " + ((LeafReaderContext)reader.leaves().get(0)).reader().numDocs() + " documents");
                }
                leafReader = ((LeafReaderContext)reader.leaves().get(0)).reader();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EngineException(this.shardId, "failed to create an in-memory segment for get [" + this.operation.id() + "]", e, new Object[0]);
                }
            }
            writer.close();
            return leafReader;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.getDelegate().getCoreCacheHelper();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.getDelegate().getReaderCacheHelper();
        }

        public Terms terms(String field) throws IOException {
            return this.getDelegate().terms(field);
        }

        public NumericDocValues getNumericDocValues(String field) throws IOException {
            return this.getDelegate().getNumericDocValues(field);
        }

        public BinaryDocValues getBinaryDocValues(String field) throws IOException {
            return this.getDelegate().getBinaryDocValues(field);
        }

        public SortedDocValues getSortedDocValues(String field) throws IOException {
            return this.getDelegate().getSortedDocValues(field);
        }

        public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
            return this.getDelegate().getSortedNumericDocValues(field);
        }

        public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
            return this.getDelegate().getSortedSetDocValues(field);
        }

        public NumericDocValues getNormValues(String field) throws IOException {
            return this.getDelegate().getNormValues(field);
        }

        public FieldInfos getFieldInfos() {
            return this.getDelegate().getFieldInfos();
        }

        public Bits getLiveDocs() {
            return this.getDelegate().getLiveDocs();
        }

        public PointValues getPointValues(String field) throws IOException {
            return this.getDelegate().getPointValues(field);
        }

        public void checkIntegrity() throws IOException {
        }

        public LeafMetaData getMetaData() {
            return this.getDelegate().getMetaData();
        }

        public Fields getTermVectors(int docID) throws IOException {
            return this.getDelegate().getTermVectors(docID);
        }

        public int numDocs() {
            return 1;
        }

        public int maxDoc() {
            return 1;
        }

        synchronized boolean assertMemorySegmentStatus(boolean loaded) {
            if (loaded) {
                assert (this.delegate.get() != null) : "Expected an in memory segment was loaded; but it wasn't. Please check the reader wrapper implementation";
            } else assert (this.delegate.get() == null) : "Expected an in memory segment wasn't loaded; but it was. Please check the reader wrapper implementation";
            return true;
        }

        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            assert (this.assertMemorySegmentStatus(true));
            this.getDelegate().document(docID, visitor);
        }

        protected void doClose() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{(Closeable)this.delegate.get(), this.directory});
        }
    }
}

