/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.lookup.SourceLookup;

public abstract class SourceValueFetcher
implements ValueFetcher {
    private final Set<String> sourcePaths;
    @Nullable
    private final Object nullValue;

    public SourceValueFetcher(String fieldName, SearchExecutionContext context) {
        this(fieldName, context, null);
    }

    public SourceValueFetcher(String fieldName, SearchExecutionContext context, Object nullValue) {
        this.sourcePaths = context.sourcePath(fieldName);
        this.nullValue = nullValue;
    }

    @Override
    public List<Object> fetchValues(SourceLookup lookup) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String path : this.sourcePaths) {
            Object sourceValue = lookup.extractValue(path, this.nullValue);
            if (sourceValue == null) continue;
            ArrayDeque<Object> queue = new ArrayDeque<Object>();
            queue.add(sourceValue);
            while (!queue.isEmpty()) {
                Object value = queue.poll();
                if (value instanceof List) {
                    for (Object o : (List)value) {
                        if (o == null) continue;
                        queue.add(o);
                    }
                    continue;
                }
                try {
                    Object parsedValue = this.parseSourceValue(value);
                    if (parsedValue == null) continue;
                    values.add(parsedValue);
                }
                catch (Exception exception) {
                }
            }
        }
        return values;
    }

    protected abstract Object parseSourceValue(Object var1);

    public static SourceValueFetcher identity(String fieldName, SearchExecutionContext context, String format) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + fieldName + "] doesn't support formats.");
        }
        return new SourceValueFetcher(fieldName, context){

            @Override
            protected Object parseSourceValue(Object value) {
                return value;
            }
        };
    }

    public static SourceValueFetcher toString(String fieldName, SearchExecutionContext context, String format) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + fieldName + "] doesn't support formats.");
        }
        return new SourceValueFetcher(fieldName, context){

            @Override
            protected Object parseSourceValue(Object value) {
                return value.toString();
            }
        };
    }
}

