/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.flattened;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DynamicKeyFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldParser;
import org.elasticsearch.index.mapper.flattened.KeyedFlattenedLeafFieldData;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public final class FlattenedFieldMapper
extends DynamicKeyFieldMapper {
    public static final String CONTENT_TYPE = "flattened";
    private static final String KEYED_FIELD_SUFFIX = "._keyed";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final FlattenedFieldParser fieldParser;
    private final Builder builder;

    private static Builder builder(Mapper in) {
        return ((FlattenedFieldMapper)in).builder;
    }

    private FlattenedFieldMapper(String simpleName, MappedFieldType mappedFieldType, Builder builder) {
        super(simpleName, mappedFieldType, Lucene.KEYWORD_ANALYZER, FieldMapper.CopyTo.empty());
        this.builder = builder;
        this.fieldParser = new FlattenedFieldParser(mappedFieldType.name(), mappedFieldType.name() + KEYED_FIELD_SUFFIX, mappedFieldType, builder.depthLimit.get(), (Integer)builder.ignoreAbove.get(), (String)builder.nullValue.get());
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    int depthLimit() {
        return this.builder.depthLimit.get();
    }

    int ignoreAbove() {
        return (Integer)this.builder.ignoreAbove.get();
    }

    @Override
    public RootFlattenedFieldType fieldType() {
        return (RootFlattenedFieldType)super.fieldType();
    }

    @Override
    public KeyedFlattenedFieldType keyedFieldType(String key) {
        return new KeyedFlattenedFieldType(this.name(), key, this.fieldType());
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            return;
        }
        if (!this.mappedFieldType.isSearchable() && !this.mappedFieldType.hasDocValues()) {
            context.parser().skipChildren();
            return;
        }
        XContentParser xContentParser = context.parser();
        context.doc().addAll(this.fieldParser.parse(xContentParser));
        if (!this.mappedFieldType.hasDocValues()) {
            this.createFieldNamesField(context);
        }
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Integer> depthLimit = FieldMapper.Parameter.intParam("depth_limit", true, m -> FlattenedFieldMapper.builder((Mapper)m).depthLimit.get(), 20).setValidator(v -> {
            if (v < 0) {
                throw new IllegalArgumentException("[depth_limit] must be positive, got [" + v + "]");
            }
        });
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> FlattenedFieldMapper.builder((Mapper)m).indexed.get(), true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> FlattenedFieldMapper.builder((Mapper)m).hasDocValues.get(), true);
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam("null_value", false, m -> FlattenedFieldMapper.builder((Mapper)m).nullValue.get(), null).acceptsNull();
        private final FieldMapper.Parameter<Boolean> eagerGlobalOrdinals = FieldMapper.Parameter.boolParam("eager_global_ordinals", true, m -> FlattenedFieldMapper.builder((Mapper)m).eagerGlobalOrdinals.get(), false);
        private final FieldMapper.Parameter<Integer> ignoreAbove = FieldMapper.Parameter.intParam("ignore_above", true, m -> FlattenedFieldMapper.builder((Mapper)m).ignoreAbove.get(), Integer.MAX_VALUE);
        private final FieldMapper.Parameter<String> indexOptions = FieldMapper.Parameter.restrictedStringParam("index_options", false, m -> FlattenedFieldMapper.builder((Mapper)m).indexOptions.get(), "docs", "freqs");
        private final FieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> FlattenedFieldMapper.builder((Mapper)m).similarity.get());
        private final FieldMapper.Parameter<Boolean> splitQueriesOnWhitespace = FieldMapper.Parameter.boolParam("split_queries_on_whitespace", true, m -> FlattenedFieldMapper.builder((Mapper)m).splitQueriesOnWhitespace.get(), false);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.depthLimit, this.nullValue, this.eagerGlobalOrdinals, this.ignoreAbove, this.indexOptions, this.similarity, this.splitQueriesOnWhitespace, this.meta);
        }

        @Override
        public FlattenedFieldMapper build(ContentPath contentPath) {
            FieldMapper.MultiFields multiFields = this.multiFieldsBuilder.build(this, contentPath);
            if (multiFields.iterator().hasNext()) {
                throw new IllegalArgumentException("flattened field [" + this.name + "] does not support [fields]");
            }
            FieldMapper.CopyTo copyTo = this.copyTo.build();
            if (!copyTo.copyToFields().isEmpty()) {
                throw new IllegalArgumentException("flattened field [" + this.name + "] does not support [copy_to]");
            }
            RootFlattenedFieldType ft = new RootFlattenedFieldType(this.buildFullName(contentPath), (boolean)this.indexed.get(), (boolean)this.hasDocValues.get(), this.meta.get(), this.splitQueriesOnWhitespace.get(), this.eagerGlobalOrdinals.get());
            return new FlattenedFieldMapper(this.name, (MappedFieldType)ft, this);
        }
    }

    public static final class RootFlattenedFieldType
    extends StringFieldType {
        private final boolean splitQueriesOnWhitespace;
        private final boolean eagerGlobalOrdinals;

        public RootFlattenedFieldType(String name, boolean indexed, boolean hasDocValues, Map<String, String> meta, boolean splitQueriesOnWhitespace, boolean eagerGlobalOrdinals) {
            super(name, indexed, false, hasDocValues, splitQueriesOnWhitespace ? TextSearchInfo.WHITESPACE_MATCH_ONLY : TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.splitQueriesOnWhitespace = splitQueriesOnWhitespace;
            this.eagerGlobalOrdinals = eagerGlobalOrdinals;
        }

        @Override
        public String typeName() {
            return FlattenedFieldMapper.CONTENT_TYPE;
        }

        @Override
        public boolean eagerGlobalOrdinals() {
            return this.eagerGlobalOrdinals;
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.KEYWORD);
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.identity(this.name(), context, format);
        }
    }

    public static final class KeyedFlattenedFieldType
    extends StringFieldType {
        private final String key;
        private final String rootName;

        KeyedFlattenedFieldType(String rootName, boolean indexed, boolean hasDocValues, String key, boolean splitQueriesOnWhitespace, Map<String, String> meta) {
            super(rootName + FlattenedFieldMapper.KEYED_FIELD_SUFFIX, indexed, false, hasDocValues, splitQueriesOnWhitespace ? TextSearchInfo.WHITESPACE_MATCH_ONLY : TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.key = key;
            this.rootName = rootName;
        }

        private KeyedFlattenedFieldType(String rootName, String key, RootFlattenedFieldType ref) {
            this(rootName, ref.isSearchable(), ref.hasDocValues(), key, ref.splitQueriesOnWhitespace, ref.meta());
        }

        @Override
        public String typeName() {
            return FlattenedFieldMapper.CONTENT_TYPE;
        }

        public String key() {
            return this.key;
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            Term term = new Term(this.name(), FlattenedFieldParser.createKeyedValue(this.key, ""));
            return new PrefixQuery(term);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            if (lowerTerm == null || upperTerm == null) {
                throw new IllegalArgumentException("[range] queries on keyed [flattened] fields must include both an upper and a lower bound.");
            }
            return super.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, context);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context) {
            throw new UnsupportedOperationException("[fuzzy] queries are not currently supported on keyed [flattened] fields.");
        }

        @Override
        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            throw new UnsupportedOperationException("[regexp] queries are not currently supported on keyed [flattened] fields.");
        }

        @Override
        public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            throw new UnsupportedOperationException("[wildcard] queries are not currently supported on keyed [flattened] fields.");
        }

        @Override
        public Query termQueryCaseInsensitive(Object value, SearchExecutionContext context) {
            AutomatonQuery query = AutomatonQueries.caseInsensitiveTermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
            if (this.boost() != 1.0f) {
                query = new BoostQuery((Query)query, this.boost());
            }
            return query;
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            if (value == null) {
                return null;
            }
            String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            String keyedValue = FlattenedFieldParser.createKeyedValue(this.key, stringValue);
            return new BytesRef((CharSequence)keyedValue);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new KeyedFlattenedFieldData.Builder(this.name(), this.key, CoreValuesSourceType.KEYWORD);
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.rootName + "." + this.key + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return SourceValueFetcher.identity(this.rootName + "." + this.key, context, format);
        }
    }

    public static class KeyedFlattenedFieldData
    implements IndexOrdinalsFieldData {
        private final String key;
        private final IndexOrdinalsFieldData delegate;

        private KeyedFlattenedFieldData(String key, IndexOrdinalsFieldData delegate) {
            this.delegate = delegate;
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public String getFieldName() {
            return this.delegate.getFieldName();
        }

        @Override
        public ValuesSourceType getValuesSourceType() {
            return this.delegate.getValuesSourceType();
        }

        @Override
        public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
            BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
            return new SortField(this.getFieldName(), (FieldComparatorSource)source, reverse);
        }

        @Override
        public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
            throw new IllegalArgumentException("only supported on numeric fields");
        }

        @Override
        public LeafOrdinalsFieldData load(LeafReaderContext context) {
            LeafOrdinalsFieldData fieldData = (LeafOrdinalsFieldData)this.delegate.load(context);
            return new KeyedFlattenedLeafFieldData(this.key, fieldData);
        }

        @Override
        public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
            LeafOrdinalsFieldData fieldData = (LeafOrdinalsFieldData)this.delegate.loadDirect(context);
            return new KeyedFlattenedLeafFieldData(this.key, fieldData);
        }

        @Override
        public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
            IndexOrdinalsFieldData fieldData = this.delegate.loadGlobal(indexReader);
            return new KeyedFlattenedFieldData(this.key, fieldData);
        }

        @Override
        public IndexOrdinalsFieldData loadGlobalDirect(DirectoryReader indexReader) throws Exception {
            IndexOrdinalsFieldData fieldData = this.delegate.loadGlobalDirect(indexReader);
            return new KeyedFlattenedFieldData(this.key, fieldData);
        }

        @Override
        public OrdinalMap getOrdinalMap() {
            throw new UnsupportedOperationException("The field data for the flattened field [" + this.delegate.getFieldName() + "] does not allow access to the underlying ordinal map.");
        }

        @Override
        public boolean supportsGlobalOrdinalsMapping() {
            return false;
        }

        public static class Builder
        implements IndexFieldData.Builder {
            private final String fieldName;
            private final String key;
            private final ValuesSourceType valuesSourceType;

            Builder(String fieldName, String key, ValuesSourceType valuesSourceType) {
                this.fieldName = fieldName;
                this.key = key;
                this.valuesSourceType = valuesSourceType;
            }

            @Override
            public IndexFieldData<?> build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
                SortedSetOrdinalsIndexFieldData delegate = new SortedSetOrdinalsIndexFieldData(cache, this.fieldName, this.valuesSourceType, breakerService, AbstractLeafOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION);
                return new KeyedFlattenedFieldData(this.key, delegate);
            }
        }
    }

    private static class Defaults {
        public static final int DEPTH_LIMIT = 20;

        private Defaults() {
        }
    }
}

