/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.MergedPointRangeQuery;

public class QueryToFilterAdapter<Q extends Query> {
    private final IndexSearcher searcher;
    private final String key;
    private final Q query;
    private Weight weight;
    private BulkScorer[] bulkScorers;
    private int scorersPreparedWhileEstimatingCost;

    public static QueryToFilterAdapter<?> build(IndexSearcher searcher, String key, Query query) throws IOException {
        if ((query = searcher.rewrite(query)) instanceof TermQuery) {
            return new TermQueryToFilterAdapter(searcher, key, (TermQuery)query);
        }
        if (query instanceof MatchAllDocsQuery) {
            return new MatchAllQueryToFilterAdapter(searcher, key, (MatchAllDocsQuery)query);
        }
        if (query instanceof MatchNoDocsQuery) {
            return new MatchNoneQueryToFilterAdapter(searcher, key, (MatchNoDocsQuery)query);
        }
        return new QueryToFilterAdapter<Query>(searcher, key, query);
    }

    private QueryToFilterAdapter(IndexSearcher searcher, String key, Q query) {
        this.searcher = searcher;
        this.key = key;
        this.query = query;
    }

    Q query() {
        return this.query;
    }

    public final String key() {
        return this.key;
    }

    protected final IndexSearcher searcher() {
        return this.searcher;
    }

    protected final boolean countCanUseMetadata(FiltersAggregator.Counter counter, Bits live) {
        if (live != null) {
            return false;
        }
        return counter.docCount.alwaysOne();
    }

    QueryToFilterAdapter<?> union(Query extraQuery) throws IOException {
        Query merged;
        extraQuery = this.searcher().rewrite(extraQuery);
        if (extraQuery instanceof MatchAllDocsQuery) {
            return this;
        }
        Query unwrappedQuery = QueryToFilterAdapter.unwrap(this.query);
        Query unwrappedExtraQuery = QueryToFilterAdapter.unwrap(extraQuery);
        if (unwrappedQuery instanceof PointRangeQuery && unwrappedExtraQuery instanceof PointRangeQuery && (merged = MergedPointRangeQuery.merge((PointRangeQuery)unwrappedQuery, (PointRangeQuery)unwrappedExtraQuery)) != null) {
            return new QueryToFilterAdapter<Query>(this.searcher(), this.key(), merged);
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(this.query, BooleanClause.Occur.MUST);
        builder.add(extraQuery, BooleanClause.Occur.MUST);
        return new QueryToFilterAdapter<BooleanQuery>(this.searcher(), this.key(), builder.build());
    }

    private static Query unwrap(Query query) {
        while (true) {
            if (query instanceof ConstantScoreQuery) {
                query = ((ConstantScoreQuery)query).getQuery();
                continue;
            }
            if (query instanceof IndexSortSortedNumericDocValuesRangeQuery) {
                query = ((IndexSortSortedNumericDocValuesRangeQuery)query).getFallbackQuery();
                continue;
            }
            if (!(query instanceof IndexOrDocValuesQuery)) break;
            query = ((IndexOrDocValuesQuery)query).getIndexQuery();
        }
        return query;
    }

    IntPredicate matchingDocIds(LeafReaderContext ctx) throws IOException {
        return arg_0 -> ((Bits)Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), this.weight().scorerSupplier(ctx))).get(arg_0);
    }

    long count(LeafReaderContext ctx, FiltersAggregator.Counter counter, Bits live) throws IOException {
        BulkScorer scorer = this.bulkScorer(ctx, () -> {});
        if (scorer == null) {
            return 0L;
        }
        scorer.score((LeafCollector)counter, live);
        return counter.readAndReset(ctx);
    }

    long estimateCountCost(LeafReaderContext ctx, CheckedSupplier<Boolean, IOException> canUseMetadata) throws IOException {
        return this.estimateCollectCost(ctx);
    }

    void collect(LeafReaderContext ctx, LeafCollector collector, Bits live) throws IOException {
        BulkScorer scorer = this.bulkScorer(ctx, () -> {});
        if (scorer == null) {
            return;
        }
        scorer.score(collector, live);
    }

    long estimateCollectCost(LeafReaderContext ctx) throws IOException {
        BulkScorer scorer = this.bulkScorer(ctx, () -> ++this.scorersPreparedWhileEstimatingCost);
        if (scorer == null) {
            return 0L;
        }
        return scorer.cost();
    }

    void collectDebugInfo(BiConsumer<String, Object> add) {
        add.accept("query", this.query.toString());
        add.accept("scorers_prepared_while_estimating_cost", this.scorersPreparedWhileEstimatingCost);
    }

    private BulkScorer bulkScorer(LeafReaderContext ctx, Runnable onPrepare) throws IOException {
        if (this.bulkScorers == null) {
            this.bulkScorers = new BulkScorer[this.searcher().getIndexReader().leaves().size()];
        }
        if (this.bulkScorers[ctx.ord] == null) {
            onPrepare.run();
            this.bulkScorers[ctx.ord] = this.weight().bulkScorer(ctx);
            return this.bulkScorers[ctx.ord];
        }
        return this.bulkScorers[ctx.ord];
    }

    private Weight weight() throws IOException {
        if (this.weight == null) {
            this.weight = this.searcher().createWeight(this.query, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
        return this.weight;
    }

    /* synthetic */ QueryToFilterAdapter(IndexSearcher x0, String x1, Query x2, 1 x3) {
        this(x0, x1, x2);
    }

    private static class TermQueryToFilterAdapter
    extends QueryToFilterAdapter<TermQuery> {
        private int resultsFromMetadata;

        private TermQueryToFilterAdapter(IndexSearcher searcher, String key, TermQuery query) {
            super(searcher, key, (Query)query, null);
        }

        @Override
        long count(LeafReaderContext ctx, FiltersAggregator.Counter counter, Bits live) throws IOException {
            if (this.countCanUseMetadata(counter, live)) {
                ++this.resultsFromMetadata;
                return ctx.reader().docFreq(((TermQuery)this.query()).getTerm());
            }
            return super.count(ctx, counter, live);
        }

        @Override
        long estimateCountCost(LeafReaderContext ctx, CheckedSupplier<Boolean, IOException> canUseMetadata) throws IOException {
            if (canUseMetadata.get().booleanValue()) {
                return 0L;
            }
            return super.estimateCountCost(ctx, canUseMetadata);
        }

        @Override
        void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("specialized_for", "term");
            add.accept("results_from_metadata", this.resultsFromMetadata);
        }
    }

    private static class MatchAllQueryToFilterAdapter
    extends QueryToFilterAdapter<MatchAllDocsQuery> {
        private int resultsFromMetadata;

        private MatchAllQueryToFilterAdapter(IndexSearcher searcher, String key, MatchAllDocsQuery query) {
            super(searcher, key, (Query)query, null);
        }

        @Override
        QueryToFilterAdapter<?> union(Query extraQuery) throws IOException {
            return QueryToFilterAdapter.build(this.searcher(), this.key(), extraQuery);
        }

        @Override
        IntPredicate matchingDocIds(LeafReaderContext ctx) throws IOException {
            return l -> true;
        }

        @Override
        long count(LeafReaderContext ctx, FiltersAggregator.Counter counter, Bits live) throws IOException {
            if (this.countCanUseMetadata(counter, live)) {
                ++this.resultsFromMetadata;
                return ctx.reader().maxDoc();
            }
            return super.count(ctx, counter, live);
        }

        @Override
        long estimateCountCost(LeafReaderContext ctx, CheckedSupplier<Boolean, IOException> canUseMetadata) throws IOException {
            return canUseMetadata.get() != false ? 0L : (long)ctx.reader().maxDoc();
        }

        @Override
        void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("specialized_for", "match_all");
            add.accept("results_from_metadata", this.resultsFromMetadata);
        }
    }

    private static class MatchNoneQueryToFilterAdapter
    extends QueryToFilterAdapter<MatchNoDocsQuery> {
        private MatchNoneQueryToFilterAdapter(IndexSearcher searcher, String key, MatchNoDocsQuery query) {
            super(searcher, key, (Query)query, null);
        }

        @Override
        QueryToFilterAdapter<?> union(Query extraQuery) throws IOException {
            return this;
        }

        @Override
        IntPredicate matchingDocIds(LeafReaderContext ctx) throws IOException {
            return l -> false;
        }

        @Override
        long count(LeafReaderContext ctx, FiltersAggregator.Counter counter, Bits live) throws IOException {
            return 0L;
        }

        @Override
        long estimateCountCost(LeafReaderContext ctx, CheckedSupplier<Boolean, IOException> canUseMetadata) throws IOException {
            return 0L;
        }

        @Override
        void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("specialized_for", "match_none");
        }
    }
}

