/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.script.AbstractFieldScript;
import org.elasticsearch.script.Script;

abstract class AbstractScriptFieldQuery<S extends AbstractFieldScript>
extends Query {
    protected static final float MATCH_COST = 9000.0f;
    private final Script script;
    private final String fieldName;
    private final Function<LeafReaderContext, S> scriptContextFunction;

    AbstractScriptFieldQuery(Script script, String fieldName, Function<LeafReaderContext, S> scriptContextFunction) {
        this.script = Objects.requireNonNull(script);
        this.fieldName = Objects.requireNonNull(fieldName);
        this.scriptContextFunction = scriptContextFunction;
    }

    final Function<LeafReaderContext, S> scriptContextFunction() {
        return this.scriptContextFunction;
    }

    final Script script() {
        return this.script;
    }

    final String fieldName() {
        return this.fieldName;
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, final float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            public Scorer scorer(LeafReaderContext ctx) {
                final AbstractFieldScript scriptContext = (AbstractFieldScript)AbstractScriptFieldQuery.this.scriptContextFunction.apply(ctx);
                DocIdSetIterator approximation = DocIdSetIterator.all((int)ctx.reader().maxDoc());
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                    public boolean matches() {
                        return AbstractScriptFieldQuery.this.matches(scriptContext, this.approximation.docID());
                    }

                    public float matchCost() {
                        return 9000.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Explanation constantExplanation = super.explain(context, doc);
                if (constantExplanation.isMatch()) {
                    return AbstractScriptFieldQuery.this.explainMatch(boost, constantExplanation.getDescription());
                }
                return constantExplanation;
            }
        };
    }

    protected abstract boolean matches(S var1, int var2);

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.script, this.fieldName);
    }

    public boolean equals(Object obj) {
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractScriptFieldQuery other = (AbstractScriptFieldQuery)((Object)obj);
        return this.script.equals(other.script) && this.fieldName.equals(other.fieldName);
    }

    final Explanation explainMatch(float boost, String description) {
        return Explanation.match((Number)Float.valueOf(boost), (String)description, (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf(boost), (String)"boost * runtime_field_score", (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf(boost), (String)"boost", (Explanation[])new Explanation[0]), Explanation.match((Number)1.0, (String)"runtime_field_score is always 1", (Explanation[])new Explanation[0])})});
    }
}

