/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.android;

import java.util.Collections;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.android.AbstractAndroidManifestCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Element;

@Rule(key="S5594")
public class AndroidExportedContentPermissionsCheck
extends AbstractAndroidManifestCheck {
    private static final String MESSAGE = "Implement permissions on this exported component.";
    private final XPathExpression xPathExpression = XPathBuilder.forExpression("/manifest/application/*[ (self::provider or self::activity or self::service)and not(@n:exported='false')and (@n:exported='true' or intent-filter)and not(@n:permission or (@n:readPermission and @n:writePermission))and not(intent-filter/action[@n:name='android.intent.action.MAIN'])]").withNamespace("n", "http://schemas.android.com/apk/res/android").build();

    @Override
    protected void scanAndroidManifest(XmlFile file) {
        this.evaluateAsList(this.xPathExpression, file.getDocument()).forEach(node -> this.reportIssue(XmlFile.nameLocation((Element)node), MESSAGE, Collections.emptyList()));
    }
}

