/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.cfg;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;

public class CfgUtils {
    private CfgUtils() {
    }

    public static Set<CfgBlock> unreachableBlocks(ControlFlowGraph cfg) {
        HashSet<CfgBlock> reachableBlocks = new HashSet<CfgBlock>();
        ArrayDeque<CfgBlock> workList = new ArrayDeque<CfgBlock>();
        workList.push(cfg.start());
        while (!workList.isEmpty()) {
            CfgBlock currentBlock = (CfgBlock)workList.pop();
            if (!reachableBlocks.add(currentBlock)) continue;
            currentBlock.successors().forEach(workList::push);
        }
        return CfgUtils.difference(cfg.blocks(), reachableBlocks);
    }

    private static Set<CfgBlock> difference(Set<CfgBlock> a, Set<CfgBlock> b) {
        HashSet<CfgBlock> result = new HashSet<CfgBlock>(a);
        result.removeAll(b);
        return result;
    }
}

