/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.apache.lucene.search.grouping.CollapsingDocValuesSource;
import org.apache.lucene.search.grouping.CollectedSearchGroup;
import org.apache.lucene.search.grouping.FirstPassGroupingCollector;
import org.apache.lucene.search.grouping.GroupSelector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.MappedFieldType;

public final class CollapsingTopDocsCollector<T>
extends FirstPassGroupingCollector<T> {
    protected final String collapseField;
    protected final Sort sort;
    protected Scorable scorer;
    private int totalHitCount;

    CollapsingTopDocsCollector(GroupSelector<T> groupSelector, String collapseField, Sort sort, int topN) {
        super(groupSelector, sort, topN);
        this.collapseField = collapseField;
        this.sort = sort;
    }

    public CollapseTopFieldDocs getTopDocs() throws IOException {
        Collection groups = super.getTopGroups(0);
        if (groups == null) {
            TotalHits totalHits = new TotalHits(0L, TotalHits.Relation.EQUAL_TO);
            return new CollapseTopFieldDocs(this.collapseField, totalHits, new ScoreDoc[0], this.sort.getSort(), new Object[0]);
        }
        ScoreDoc[] docs = new FieldDoc[groups.size()];
        Object[] collapseValues = new Object[groups.size()];
        int scorePos = -1;
        for (int index = 0; index < this.sort.getSort().length; ++index) {
            SortField sortField = this.sort.getSort()[index];
            if (sortField.getType() != SortField.Type.SCORE) continue;
            scorePos = index;
            break;
        }
        int pos = 0;
        Iterator it = this.orderedGroups.iterator();
        for (SearchGroup group : groups) {
            assert (it.hasNext());
            CollectedSearchGroup col = (CollectedSearchGroup)it.next();
            float score = Float.NaN;
            if (scorePos != -1) {
                score = ((Float)group.sortValues[scorePos]).floatValue();
            }
            docs[pos] = new FieldDoc(col.topDoc, score, group.sortValues);
            collapseValues[pos] = group.groupValue;
            ++pos;
        }
        TotalHits totalHits = new TotalHits(this.totalHitCount, TotalHits.Relation.EQUAL_TO);
        return new CollapseTopFieldDocs(this.collapseField, totalHits, docs, this.sort.getSort(), collapseValues);
    }

    public ScoreMode scoreMode() {
        if (super.scoreMode().needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public void setScorer(Scorable scorer) throws IOException {
        super.setScorer(scorer);
        this.scorer = scorer;
    }

    public void collect(int doc) throws IOException {
        super.collect(doc);
        ++this.totalHitCount;
    }

    public static CollapsingTopDocsCollector<?> createNumeric(String collapseField, MappedFieldType collapseFieldType, Sort sort, int topN) {
        return new CollapsingTopDocsCollector<Long>(new CollapsingDocValuesSource.Numeric(collapseFieldType), collapseField, sort, topN);
    }

    public static CollapsingTopDocsCollector<?> createKeyword(String collapseField, MappedFieldType collapseFieldType, Sort sort, int topN) {
        return new CollapsingTopDocsCollector<BytesRef>(new CollapsingDocValuesSource.Keyword(collapseFieldType), collapseField, sort, topN);
    }
}

