/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.NotifyOnceListener;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.CheckedSupplier;

public interface ActionListener<Response> {
    public void onResponse(Response var1);

    public void onFailure(Exception var1);

    default public <T> ActionListener<T> map(CheckedFunction<T, Response, Exception> fn) {
        return new MappedActionListener(fn, this);
    }

    public static <Response> ActionListener<Response> wrap(final CheckedConsumer<Response, ? extends Exception> onResponse, final Consumer<Exception> onFailure) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    onResponse.accept(response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                onFailure.accept(e);
            }

            public String toString() {
                return "WrappedActionListener{" + onResponse + "}{" + onFailure + "}";
            }
        };
    }

    default public ActionListener<Response> delegateResponse(BiConsumer<ActionListener<Response>, Exception> bc) {
        return new DelegatingActionListener(this, bc);
    }

    default public <T> ActionListener<T> delegateFailure(BiConsumer<ActionListener<Response>, T> bc) {
        return new DelegatingFailureActionListener<T, Response>(this, bc);
    }

    public static <Response> ActionListener<Response> wrap(final Runnable runnable) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    runnable.run();
                }
                catch (RuntimeException e) {
                    assert (false) : e;
                    throw e;
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    runnable.run();
                }
                catch (RuntimeException ex) {
                    ex.addSuppressed(e);
                    assert (false) : ex;
                    throw ex;
                }
            }

            public String toString() {
                return "RunnableWrappingActionListener{" + runnable + "}";
            }
        };
    }

    public static <Response> BiConsumer<Response, Exception> toBiConsumer(ActionListener<Response> listener) {
        return (response, throwable) -> {
            if (throwable == null) {
                listener.onResponse(response);
            } else {
                listener.onFailure((Exception)throwable);
            }
        };
    }

    public static <Response> void onResponse(Iterable<ActionListener<Response>> listeners, Response response) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onResponse(response);
            }
            catch (Exception ex) {
                try {
                    listener.onFailure(ex);
                }
                catch (Exception ex1) {
                    exceptionList.add(ex1);
                }
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <Response> void onFailure(Iterable<ActionListener<Response>> listeners, Exception failure) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onFailure(failure);
            }
            catch (Exception ex) {
                exceptionList.add(ex);
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <Response> ActionListener<Response> runAfter(ActionListener<Response> delegate, Runnable runAfter) {
        return new RunAfterActionListener<Response>(delegate, runAfter);
    }

    public static <Response> ActionListener<Response> runBefore(ActionListener<Response> delegate, CheckedRunnable<?> runBefore) {
        return new RunBeforeActionListener<Response>(delegate, runBefore);
    }

    public static <Response> ActionListener<Response> notifyOnce(final ActionListener<Response> delegate) {
        return new NotifyOnceListener<Response>(){

            @Override
            protected void innerOnResponse(Response response) {
                delegate.onResponse(response);
            }

            @Override
            protected void innerOnFailure(Exception e) {
                delegate.onFailure(e);
            }
        };
    }

    public static <Response> void completeWith(ActionListener<Response> listener, CheckedSupplier<Response, ? extends Exception> supplier) {
        Response response;
        try {
            response = supplier.get();
        }
        catch (Exception e) {
            try {
                listener.onFailure(e);
            }
            catch (RuntimeException ex) {
                if (!4.$assertionsDisabled) {
                    throw new AssertionError((Object)ex);
                }
                throw ex;
            }
            return;
        }
        try {
            listener.onResponse(response);
        }
        catch (RuntimeException ex) {
            if (!4.$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            throw ex;
        }
    }

    static {
        if (4.$assertionsDisabled) {
            // empty if block
        }
    }

    public static final class MappedActionListener<Response, MappedResponse>
    extends Delegating<Response, MappedResponse> {
        private final CheckedFunction<Response, MappedResponse, Exception> fn;

        private MappedActionListener(CheckedFunction<Response, MappedResponse, Exception> fn, ActionListener<MappedResponse> delegate) {
            super(delegate);
            this.fn = fn;
        }

        @Override
        public void onResponse(Response response) {
            MappedResponse mapped;
            try {
                mapped = this.fn.apply(response);
            }
            catch (Exception e) {
                this.onFailure(e);
                return;
            }
            try {
                this.delegate.onResponse(mapped);
            }
            catch (RuntimeException e) {
                assert (false) : new AssertionError("map: listener.onResponse failed", e);
                throw e;
            }
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.fn;
        }

        @Override
        public <T> ActionListener<T> map(CheckedFunction<T, Response, Exception> fn) {
            return new MappedActionListener<Object, Object>(t -> this.fn.apply(fn.apply(t)), this.delegate);
        }
    }

    public static final class DelegatingActionListener<T>
    extends Delegating<T, T> {
        private final BiConsumer<ActionListener<T>, Exception> bc;

        DelegatingActionListener(ActionListener<T> delegate, BiConsumer<ActionListener<T>, Exception> bc) {
            super(delegate);
            this.bc = bc;
        }

        @Override
        public void onResponse(T t) {
            this.delegate.onResponse(t);
        }

        @Override
        public void onFailure(Exception e) {
            try {
                this.bc.accept(this.delegate, e);
            }
            catch (RuntimeException ex) {
                if (ex != e) {
                    ex.addSuppressed(e);
                }
                assert (false) : new AssertionError("listener.onFailure failed", ex);
                throw ex;
            }
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.bc;
        }
    }

    public static final class DelegatingFailureActionListener<T, R>
    extends Delegating<T, R> {
        private final BiConsumer<ActionListener<R>, T> bc;

        DelegatingFailureActionListener(ActionListener<R> delegate, BiConsumer<ActionListener<R>, T> bc) {
            super(delegate);
            this.bc = bc;
        }

        @Override
        public void onResponse(T t) {
            this.bc.accept(this.delegate, (ActionListener)t);
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.bc;
        }
    }

    public static final class RunAfterActionListener<T>
    extends Delegating<T, T> {
        private final Runnable runAfter;

        protected RunAfterActionListener(ActionListener<T> delegate, Runnable runAfter) {
            super(delegate);
            this.runAfter = runAfter;
        }

        @Override
        public void onResponse(T response) {
            try {
                this.delegate.onResponse(response);
            }
            finally {
                this.runAfter.run();
            }
        }

        @Override
        public void onFailure(Exception e) {
            try {
                super.onFailure(e);
            }
            finally {
                this.runAfter.run();
            }
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.runAfter;
        }
    }

    public static final class RunBeforeActionListener<T>
    extends Delegating<T, T> {
        private final CheckedRunnable<?> runBefore;

        protected RunBeforeActionListener(ActionListener<T> delegate, CheckedRunnable<?> runBefore) {
            super(delegate);
            this.runBefore = runBefore;
        }

        @Override
        public void onResponse(T response) {
            try {
                this.runBefore.run();
            }
            catch (Exception ex) {
                super.onFailure(ex);
                return;
            }
            this.delegate.onResponse(response);
        }

        @Override
        public void onFailure(Exception e) {
            try {
                this.runBefore.run();
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            super.onFailure(e);
        }

        @Override
        public String toString() {
            return super.toString() + "/" + this.runBefore;
        }
    }

    public static abstract class Delegating<Response, DelegateResponse>
    implements ActionListener<Response> {
        protected final ActionListener<DelegateResponse> delegate;

        protected Delegating(ActionListener<DelegateResponse> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onFailure(Exception e) {
            try {
                this.delegate.onFailure(e);
            }
            catch (RuntimeException ex) {
                if (ex != e) {
                    ex.addSuppressed(e);
                }
                assert (false) : new AssertionError("listener.onFailure failed", ex);
                throw ex;
            }
        }

        public String toString() {
            return this.getClass().getName() + "/" + this.delegate;
        }
    }
}

