/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.configuration;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.unit.TimeValue;

public class AddVotingConfigExclusionsRequest
extends MasterNodeRequest<AddVotingConfigExclusionsRequest> {
    public static final String DEPRECATION_MESSAGE = "nodeDescription is deprecated and will be removed, use nodeIds or nodeNames instead";
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(AddVotingConfigExclusionsRequest.class);
    private final String[] nodeDescriptions;
    private final String[] nodeIds;
    private final String[] nodeNames;
    private final TimeValue timeout;

    public AddVotingConfigExclusionsRequest(String ... nodeNames) {
        this(Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, nodeNames, TimeValue.timeValueSeconds(30L));
    }

    public AddVotingConfigExclusionsRequest(String[] nodeDescriptions, String[] nodeIds, String[] nodeNames, TimeValue timeout) {
        if (timeout.compareTo(TimeValue.ZERO) < 0) {
            throw new IllegalArgumentException("timeout [" + timeout + "] must be non-negative");
        }
        if (this.noneOrMoreThanOneIsSet(nodeDescriptions, nodeIds, nodeNames)) {
            throw new IllegalArgumentException("Please set node identifiers correctly. One and only one of [node_name], [node_names] and [node_ids] has to be set");
        }
        if (nodeDescriptions.length > 0) {
            deprecationLogger.deprecate(DeprecationCategory.API, "voting_config_exclusion", DEPRECATION_MESSAGE, new Object[0]);
        }
        this.nodeDescriptions = nodeDescriptions;
        this.nodeIds = nodeIds;
        this.nodeNames = nodeNames;
        this.timeout = timeout;
    }

    public AddVotingConfigExclusionsRequest(StreamInput in) throws IOException {
        super(in);
        this.nodeDescriptions = in.readStringArray();
        if (in.getVersion().onOrAfter(Version.V_7_8_0)) {
            this.nodeIds = in.readStringArray();
            this.nodeNames = in.readStringArray();
        } else {
            this.nodeIds = Strings.EMPTY_ARRAY;
            this.nodeNames = Strings.EMPTY_ARRAY;
        }
        this.timeout = in.readTimeValue();
        if (this.nodeDescriptions.length > 0) {
            deprecationLogger.deprecate(DeprecationCategory.API, "voting_config_exclusion", DEPRECATION_MESSAGE, new Object[0]);
        }
    }

    Set<CoordinationMetadata.VotingConfigExclusion> resolveVotingConfigExclusions(ClusterState currentState) {
        DiscoveryNodes allNodes = currentState.nodes();
        Set<CoordinationMetadata.VotingConfigExclusion> newVotingConfigExclusions = new HashSet<CoordinationMetadata.VotingConfigExclusion>();
        if (this.nodeDescriptions.length >= 1) {
            newVotingConfigExclusions = Arrays.stream(allNodes.resolveNodes(this.nodeDescriptions)).map(allNodes::get).filter(DiscoveryNode::isMasterNode).map(CoordinationMetadata.VotingConfigExclusion::new).collect(Collectors.toSet());
            if (newVotingConfigExclusions.isEmpty()) {
                throw new IllegalArgumentException("add voting config exclusions request for " + Arrays.asList(this.nodeDescriptions) + " matched no master-eligible nodes");
            }
        } else if (this.nodeIds.length >= 1) {
            for (String nodeId : this.nodeIds) {
                if (allNodes.nodeExists(nodeId)) {
                    DiscoveryNode discoveryNode = allNodes.get(nodeId);
                    if (!discoveryNode.isMasterNode()) continue;
                    newVotingConfigExclusions.add((CoordinationMetadata.VotingConfigExclusion)((Object)new CoordinationMetadata.VotingConfigExclusion(discoveryNode)));
                    continue;
                }
                newVotingConfigExclusions.add((CoordinationMetadata.VotingConfigExclusion)((Object)new CoordinationMetadata.VotingConfigExclusion(nodeId, "_absent_")));
            }
        } else {
            assert (this.nodeNames.length >= 1);
            Map existingNodes = StreamSupport.stream(allNodes.spliterator(), false).collect(Collectors.toMap(DiscoveryNode::getName, Function.identity()));
            for (String nodeName : this.nodeNames) {
                if (existingNodes.containsKey(nodeName)) {
                    DiscoveryNode discoveryNode = (DiscoveryNode)existingNodes.get(nodeName);
                    if (!discoveryNode.isMasterNode()) continue;
                    newVotingConfigExclusions.add((CoordinationMetadata.VotingConfigExclusion)((Object)new CoordinationMetadata.VotingConfigExclusion(discoveryNode)));
                    continue;
                }
                newVotingConfigExclusions.add((CoordinationMetadata.VotingConfigExclusion)((Object)new CoordinationMetadata.VotingConfigExclusion("_absent_", nodeName)));
            }
        }
        newVotingConfigExclusions.removeIf(n -> currentState.getVotingConfigExclusions().contains(n));
        return newVotingConfigExclusions;
    }

    Set<CoordinationMetadata.VotingConfigExclusion> resolveVotingConfigExclusionsAndCheckMaximum(ClusterState currentState, int maxExclusionsCount, String maximumSettingKey) {
        int newExclusionsCount;
        Set<CoordinationMetadata.VotingConfigExclusion> resolvedExclusions = this.resolveVotingConfigExclusions(currentState);
        int oldExclusionsCount = currentState.getVotingConfigExclusions().size();
        if (oldExclusionsCount + (newExclusionsCount = resolvedExclusions.size()) > maxExclusionsCount) {
            throw new IllegalArgumentException("add voting config exclusions request for " + Arrays.asList(this.nodeDescriptions) + " would add [" + newExclusionsCount + "] exclusions to the existing [" + oldExclusionsCount + "] which would exceed the maximum of [" + maxExclusionsCount + "] set by [" + maximumSettingKey + "]");
        }
        return resolvedExclusions;
    }

    private boolean noneOrMoreThanOneIsSet(String[] deprecatedNodeDescription, String[] nodeIds, String[] nodeNames) {
        if (deprecatedNodeDescription.length > 0) {
            return nodeIds.length > 0 || nodeNames.length > 0;
        }
        if (nodeIds.length > 0) {
            return nodeNames.length > 0;
        }
        return !(nodeNames.length > 0);
    }

    public String[] getNodeDescriptions() {
        return this.nodeDescriptions;
    }

    public String[] getNodeIds() {
        return this.nodeIds;
    }

    public String[] getNodeNames() {
        return this.nodeNames;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.nodeDescriptions);
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeStringArray(this.nodeIds);
            out.writeStringArray(this.nodeNames);
        }
        out.writeTimeValue(this.timeout);
    }

    @Override
    public String toString() {
        return "AddVotingConfigExclusionsRequest{nodeDescriptions=" + Arrays.asList(this.nodeDescriptions) + ", nodeIds=" + Arrays.asList(this.nodeIds) + ", nodeNames=" + Arrays.asList(this.nodeNames) + ", timeout=" + this.timeout + '}';
    }
}

